/***************************************************************************
                          idp2text.cpp  -  description
                             -------------------
    begin                : Sun Oct 7 2001
    copyright            : (C) 2001 by Ricardo Villalba
    email                : rvm@escomposlinux.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include <string>
#include <stdio.h>

#include "libidp.h"

char linea[2048];

int main(int argc, char *argv[])
{
	bool codificar=false;

	if (argc>1) {
		if ( strcmp(argv[1], "-c") == 0 ) codificar=true;

		if (strcmp(argv[1], "--help") == 0) {
			puts("");
			puts("idp2text [--help] [-c]");
			puts("   --help    Show this help / Muestra esta ayuda");
			puts("   -c        Encode into the IDP format / Codifica en formato IDP");
	        return 0;
		}
	}
	
	while (! feof( stdin ) ) {
		fgets( linea, sizeof(linea), stdin );
		//printf("'%c'", linea[0] );
		if (linea[0]=='#')
			printf("%s", linea);
		else
			printf("%s", convierte_idp(linea, codificar).c_str() );
	}


	return EXIT_SUCCESS;
}

