/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2005 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "miniwindow.h"
#include "QSimpleTextBrowser.h"
#include <QConfig.h>
#include <qlayout.h>
#include <qcolor.h>
#include <qcursor.h>
#include <qapplication.h>

MiniWindow * MiniWindow::miniwindow=NULL;
QConfig * MiniWindow::conf=NULL;

MiniWindow::MiniWindow() : QWidget(0, "miniwindow"/*, WStyle_Customize | WStyle_Tool*//*, WType_Popup*/) {
	setMinimumSize(200, 100);
	resize(200, 100 );

	_browser = new QSimpleTextBrowser( this, "browser_miniwindow" );
	_browser->cambia_color( QColor("yellow") );
	_browser->viewport()->installEventFilter(this);

	QGridLayout *l=new QGridLayout(this, 1, 1, 0, 0);
	l->addWidget( _browser, 0, 0 );

}

MiniWindow::~MiniWindow() {
}

void MiniWindow::setText( const QString & texto ) { 
	_browser->setText( texto ); 
}

QString MiniWindow::text() { 
	return _browser->text(); 
}

void MiniWindow::show() {
	QWidget *d = QApplication::desktop();
	int desktop_w = d->width();
	int desktop_h = d->height();

	int x = QCursor::pos().x() - (width()/2);
	if (x<0) x=0;

	if ( (x+width()) > desktop_w ) {
		x = desktop_w - width();
	}

	int y = QCursor::pos().y();
	if ( y > (desktop_h/2) ) {
		y = y - height() - 40;
	} else {
		y = y + 20;
	}

	move( x, y );
	QWidget::show();
}

bool MiniWindow::eventFilter(QObject *, QEvent *e) {
	if (e->type() == QEvent::MouseButtonPress ) {
		QMouseEvent *k = (QMouseEvent*)e;
		if (k->button()==LeftButton) {
			hide();
			return TRUE;
		}
    }
    return FALSE;                                                               
}

void MiniWindow::save(QConfig *conf) {
	if ( conf!=NULL) {
		debug("MiniWindow::save: Guardando configuracin");

		conf->setGroup("Miniwindow");
		conf->writeSizeEntry("WSize", size() );
		conf->writeFontEntry("font", _browser->defaultFont() );
		conf->writeColorEntry("bg_color", _browser->colorFondo() );
	} else {
		debug("MiniWindow::save: Error, conf==NULL");
	}
}

void MiniWindow::load(QConfig *conf) {
	if ( conf!=NULL) {
		debug("MiniWindow::load: Leyendo configuracin");

		conf->setGroup("Miniwindow");
		resize( conf->readSizeEntry("WSize", size() ) );
		_browser->setDefaultFont( conf->readFontEntry("font", _browser->defaultFont() ) );
		_browser->cambia_color( conf->readColorEntry("bg_color", _browser->colorFondo() ) );
	} else {
		debug("MiniWindow::load: Error, conf==NULL");
	}
}

void MiniWindow::save() {
	save( MiniWindow::conf );
}

void MiniWindow::load() {
	load( MiniWindow::conf );
}


MiniWindow *MiniWindow::defaultWindow() {
	if (MiniWindow::miniwindow==NULL) {
		debug("Creando MiniWindow::miniwindow");
		MiniWindow::miniwindow=new MiniWindow();
		MiniWindow::miniwindow->load();
	}

	return MiniWindow::miniwindow;
}

void MiniWindow::setConf( QConfig * _conf) {
	conf= _conf;
}

//Gracias a Mario Teijeiro Otero <mteijeiro@escomposlinux.org>
//por esto:
void MiniWindow::keyPressEvent (QKeyEvent *e) {
	if ( e->key() == Key_Escape )
		hide();
}


#include "miniwindow.moc.cpp"
