/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _URLMANAGER_H_
#define _URLMANAGER_H_

class QDiccionarios;
class DiccionarioBase;
class QString;

#include <qobject.h>

class UrlManager : public QObject
{
	Q_OBJECT

public:

	UrlManager(QDiccionarios *diccionarios, 
			   DiccionarioBase *actual,
               QObject * parent = 0, const char * name = 0 );

	~UrlManager();

	void setDictionary( DiccionarioBase * dict ) { dict_actual = dict; };
	DiccionarioBase *getDictionary() { return dict_actual; };

	void setRichText(bool b) { rich_text = b; };
	bool usingRichText() { return rich_text; };

	//Formato url: "dict:palabra@diccionario"
	QString text( const QString & url, bool con_formato );
	QString text( const QString & url ) { return text(url,rich_text); };

signals:
	void dictionaryChanged( DiccionarioBase *dict);
	void fraseTraducida(const QString & last_search, 
                        const QString & palabra, 
                        const QString & texto, 
                        unsigned int traducciones);
	void htmlLink( const QString & url );
	void seeManual();

protected:
	QString getDictDesc();
	bool changeDict(const QString& alias );
	QString traduce(const QString & palabra, bool con_formato);

	DiccionarioBase *dict_actual;
	QDiccionarios *dicts;

	bool rich_text;
};

extern UrlManager * url_manager;

#endif
