/* cursorops.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: cursorops.cc,v 1.12 2001/11/03 17:08:05 ralf Exp $ */

#include "cursorops.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

/******
 RowUp
*******/

const char *RowUp::name="RowUp";

bool RowUp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *RowUp::getName()
{
  return name;
}

RowUp::RowUp(Worker *tworker):FunctionProto(tworker)
{
}

RowUp::~RowUp()
{
}

RowUp *RowUp::duplicate()
{
  RowUp *ta=new RowUp(worker);
  return ta;
}

int RowUp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->up();
        }
      }
    }
  }
  return 0;
}

const char *RowUp::getDescription()
{
  return catalog.getLocaleCom(5);
}

/*************
 Ende RowUp
**************/

/********
 RowDown
*********/

const char *RowDown::name="RowDown";

bool RowDown::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *RowDown::getName()
{
  return name;
}

RowDown::RowDown(Worker *tworker):FunctionProto(tworker)
{
}

RowDown::~RowDown()
{
}

RowDown *RowDown::duplicate()
{
  RowDown *ta=new RowDown(worker);
  return ta;
}

int RowDown::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->down();
        }
      }
    }
  }
  return 0;
}

const char *RowDown::getDescription()
{
  return catalog.getLocaleCom(6);
}

/*************
 Ende RowDown
**************/

/********
 FirstRow
*********/

const char *FirstRow::name="FirstRow";

bool FirstRow::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *FirstRow::getName()
{
  return name;
}

FirstRow::FirstRow(Worker *tworker):FunctionProto(tworker)
{
}

FirstRow::~FirstRow()
{
}

FirstRow *FirstRow::duplicate()
{
  FirstRow *ta=new FirstRow(worker);
  return ta;
}

int FirstRow::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->top();
        }
      }
    }
  }
  return 0;
}

const char *FirstRow::getDescription()
{
  return catalog.getLocaleCom(9);
}

/*************
 Ende FirstRow
**************/

/********
 LastRow
*********/

const char *LastRow::name="LastRow";

bool LastRow::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *LastRow::getName()
{
  return name;
}

LastRow::LastRow(Worker *tworker):FunctionProto(tworker)
{
}

LastRow::~LastRow()
{
}

LastRow *LastRow::duplicate()
{
  LastRow *ta=new LastRow(worker);
  return ta;
}

int LastRow::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->last();
        }
      }
    }
  }
  return 0;
}

const char *LastRow::getDescription()
{
  return catalog.getLocaleCom(10);
}

/*************
 Ende LastRow
**************/

/******
 PageUp
*******/

const char *PageUp::name="PageUp";

bool PageUp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *PageUp::getName()
{
  return name;
}

PageUp::PageUp(Worker *tworker):FunctionProto(tworker)
{
}

PageUp::~PageUp()
{
}

PageUp *PageUp::duplicate()
{
  PageUp *ta=new PageUp(worker);
  return ta;
}

int PageUp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->pageup();
        }
      }
    }
  }
  return 0;
}

const char *PageUp::getDescription()
{
  return catalog.getLocaleCom(11);
}

/*************
 Ende PageUp
**************/

/******
 PageDown
*******/

const char *PageDown::name="PageDown";

bool PageDown::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *PageDown::getName()
{
  return name;
}

PageDown::PageDown(Worker *tworker):FunctionProto(tworker)
{
}

PageDown::~PageDown()
{
}

PageDown *PageDown::duplicate()
{
  PageDown *ta=new PageDown(worker);
  return ta;
}

int PageDown::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->pagedown();
        }
      }
    }
  }
  return 0;
}

const char *PageDown::getDescription()
{
  return catalog.getLocaleCom(12);
}

/*************
 Ende PageDown
**************/

/******
 SelectOp
*******/

const char *SelectOp::name="SelectOp";

bool SelectOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *SelectOp::getName()
{
  return name;
}

SelectOp::SelectOp(Worker *tworker):FunctionProto(tworker)
{
}

SelectOp::~SelectOp()
{
}

SelectOp *SelectOp::duplicate()
{
  SelectOp *ta=new SelectOp(worker);
  return ta;
}

int SelectOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->select();
        }
      }
    }
  }
  return 0;
}

const char *SelectOp::getDescription()
{
  return catalog.getLocaleCom(13);
}

/*************
 Ende SelectOp
**************/

/******
 SelectAllOp
*******/

const char *SelectAllOp::name="SelectAllOp";

bool SelectAllOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *SelectAllOp::getName()
{
  return name;
}

SelectAllOp::SelectAllOp(Worker *tworker):FunctionProto(tworker)
{
}

SelectAllOp::~SelectAllOp()
{
}

SelectAllOp *SelectAllOp::duplicate()
{
  SelectAllOp *ta=new SelectAllOp(worker);
  return ta;
}

int SelectAllOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->selectall();
        }
      }
    }
  }
  return 0;
}

const char *SelectAllOp::getDescription()
{
  return catalog.getLocaleCom(14);
}

/*************
 Ende SelectAllOp
**************/

/******
 SelectNoneOp
*******/

const char *SelectNoneOp::name="SelectNoneOp";

bool SelectNoneOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *SelectNoneOp::getName()
{
  return name;
}

SelectNoneOp::SelectNoneOp(Worker *tworker):FunctionProto(tworker)
{
}

SelectNoneOp::~SelectNoneOp()
{
}

SelectNoneOp *SelectNoneOp::duplicate()
{
  SelectNoneOp *ta=new SelectNoneOp(worker);
  return ta;
}

int SelectNoneOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->selectnone();
        }
      }
    }
  }
  return 0;
}

const char *SelectNoneOp::getDescription()
{
  return catalog.getLocaleCom(15);
}

/*************
 Ende SelectNoneOp
**************/

/******
  InvertAllOp
*******/

const char *InvertAllOp::name="InvertAllOp";

bool InvertAllOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *InvertAllOp::getName()
{
  return name;
}

InvertAllOp::InvertAllOp(Worker *tworker):FunctionProto(tworker)
{
}

InvertAllOp::~InvertAllOp()
{
}

InvertAllOp *InvertAllOp::duplicate()
{
  InvertAllOp *ta=new InvertAllOp(worker);
  return ta;
}

int InvertAllOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->invertall();
        }
      }
    }
  }
  return 0;
}

const char *InvertAllOp::getDescription()
{
  return catalog.getLocaleCom(16);
}

/*************
 Ende InvertAllOp
**************/

/******
  ParentDirOp
*******/

const char *ParentDirOp::name="ParentDirOp";

bool ParentDirOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *ParentDirOp::getName()
{
  return name;
}

ParentDirOp::ParentDirOp(Worker *tworker):FunctionProto(tworker)
{
}

ParentDirOp::~ParentDirOp()
{
}

ParentDirOp *ParentDirOp::duplicate()
{
  ParentDirOp *ta=new ParentDirOp(worker);
  return ta;
}

int ParentDirOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->parent();
        }
      }
    }
  }
  return 0;
}

const char *ParentDirOp::getDescription()
{
  return catalog.getLocaleCom(17);
}

/*************
 Ende ParentDirOp
**************/

/******
  EnterDirOp
*******/

/* Bei normalen Aufruf: aktiven Eintrag benutzen
   Bei DND: Element (muesste aktives sein) in Ziel (muss erst erkannt werden) darstellen
   Wenn diese Op einen Pfad hat (also nicht leer), dann diesen darstellen (also unabhaengig
     vom Eintrag */

const char *EnterDirOp::name="EnterDirOp";

bool EnterDirOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *EnterDirOp::getName()
{
  return name;
}

EnterDirOp::EnterDirOp(Worker *tworker):FunctionProto(tworker)
{
  dir=(char*)_allocsafe(1);
  dir[0]=0;
  enterdirmode=ENTERDIROP_ACTIVE;
}

EnterDirOp::~EnterDirOp()
{
  _freesafe(dir);
}

EnterDirOp *EnterDirOp::duplicate()
{
  EnterDirOp *ta=new EnterDirOp(worker);
  _freesafe(ta->dir);
  ta->dir=dupstring(dir);
  ta->enterdirmode=enterdirmode;
  return ta;
}

int EnterDirOp::run(ActionMessage *msg)
{
  Lister *l1;
  ListerMode *lm1;
  NormalMode *nm1;
  int erg;
  char *buttonstr,*textstr,*return_str;

  if(msg->mode==msg->AM_MODE_DNDACTION) {
    l1=((DNDMsg*)msg->extraInfo)->getDestLister();
    if(l1!=NULL) {
      // Element in l1 darstellen
      l1->switch2Mode(0);
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          FileEntry *fe=((DNDMsg*)msg->extraInfo)->getFE();
          if(fe!=NULL) nm1->enterDir(fe->fullname);
        }
      }
    }
  } else {
    if(enterdirmode==ENTERDIROP_SPECIAL) {
      if(strlen(dir)>0) {
        l1=worker->getActiveLister();
        if(l1!=NULL) {
          l1->switch2Mode(0);
          lm1=l1->getActiveMode();
          if(lm1!=NULL) {
            if(lm1->isType("NormalMode")==true) {
              nm1=(NormalMode*)lm1;
              nm1->enterDir(dir);
            }
          }
        }
      }
    } else if(enterdirmode==ENTERDIROP_REQUEST) {
      Requester *req=new Requester(worker->getAGUIX());
      textstr=catalog.getLocale(290);
      buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                  strlen(catalog.getLocale(8))+1);
      sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
                                catalog.getLocale(8));
      erg=req->string_request(catalog.getLocale(123),textstr,"",buttonstr,&return_str);
      _freesafe(buttonstr);
      if((erg==0)&&(strlen(return_str)>0)) {
        l1=worker->getActiveLister();
        if(l1!=NULL) {
          l1->switch2Mode(0);
          lm1=l1->getActiveMode();
          if(lm1!=NULL) {
            if(lm1->isType("NormalMode")==true) {
              nm1=(NormalMode*)lm1;
              nm1->enterDir(return_str);
            }
          }
        }
      }
      _freesafe(return_str);
      delete req;
    } else {
      // here we need the help of NormalMode
      l1=worker->getActiveLister();
      if(l1!=NULL) {
        lm1=l1->getActiveMode();
        if(lm1!=NULL) {
          if(lm1->isType("NormalMode")==true) {
            nm1=(NormalMode*)lm1;
            if(enterdirmode==ENTERDIROP_ACTIVE) {
              nm1->enterDirActive();
            } else {
              nm1->setActiveDir2Other();
            }
          }
        }
      }
    }
  }
  return 0;
}

const char *EnterDirOp::getDescription()
{
  return catalog.getLocaleCom(18);
}

int EnterDirOp::configure()
{
  AGUIX *aguix=worker->getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  CycleButton *rcyb;
  StringGadget *sg;
  Text *ttext;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  
  w=h=10;
  x=y=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(18))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(18));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(317),1));
  x+=ttext->getWidth()+5;
  rcyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  rcyb->addOption(catalog.getLocale(318));
  rcyb->addOption(catalog.getLocale(319));
  rcyb->addOption(catalog.getLocale(320));
  rcyb->addOption(catalog.getLocale(321));
  rcyb->resize(rcyb->getMaxSize(),rcyb->getHeight());
  switch(enterdirmode) {
    case ENTERDIROP_ACTIVE2OTHER:
      rcyb->setOption(1);
      break;
    case ENTERDIROP_SPECIAL:
      rcyb->setOption(2);
      break;
    case ENTERDIROP_REQUEST:
      rcyb->setOption(3);
      break;
    default:
      rcyb->setOption(0);
      break;
  }
  
  y+=rcyb->getHeight()+5;
  tw=x+rcyb->getWidth()+5;
  if(tw>w) w=tw;
  x=5;

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(322),1));
  x+=ttext->getWidth()+5;
  tw=w-x-5;
  if(tw<50) tw=50;
  sg=(StringGadget*)win->add(new StringGadget(aguix,x,y,tw,dir,0));
  y+=sg->getHeight()+5;
  tw=sg->getWidth()+5+x;
  if(tw>w) w=tw;
  x=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  h=y;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
        case AG_STRINGGADGET_DEACTIVATE:
          rcyb->setOption(2);
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    switch(rcyb->getSelectedOption()) {
      case 1:
        enterdirmode=ENTERDIROP_ACTIVE2OTHER;
        break;
      case 2:
        enterdirmode=ENTERDIROP_SPECIAL;
        break;
      case 3:
        enterdirmode=ENTERDIROP_REQUEST;
        break;
      default:
        enterdirmode=ENTERDIROP_ACTIVE;
        break;
    }
    _freesafe(dir);
    dir=dupstring(sg->getText());
  }
  
  win->close();
  delete win;

  return endmode;
}

bool EnterDirOp::save(Datei *fh)
{
  fh->putInt(Datei::getIntSize()+strlen(dir)+Datei::getUCharSize());
  fh->putInt(strlen(dir));
  fh->putString(dir);
  switch(enterdirmode) {
    case ENTERDIROP_ACTIVE2OTHER:
      fh->putUChar(1);
      break;
    case ENTERDIROP_SPECIAL:
      fh->putUChar(2);
      break;
    case ENTERDIROP_REQUEST:
      fh->putUChar(3);
      break;
    default:
      fh->putUChar(0);
  }
  return true;
}

int EnterDirOp::load(Datei *fh)
{
  int chunksize=fh->getInt();
  int len;
  char *str;
  unsigned char c1;
  if(chunksize>=(Datei::getIntSize()+Datei::getUCharSize())) {
    len=fh->getInt();
    chunksize-=Datei::getIntSize();
    str=fh->getString(len);
    _freesafe(dir);
    dir=str;
    chunksize-=len;
    c1=fh->getUChar();
    switch(c1) {
      case 1:
        enterdirmode=ENTERDIROP_ACTIVE2OTHER;
        break;
      case 2:
        enterdirmode=ENTERDIROP_SPECIAL;
        break;
      case 3:
        enterdirmode=ENTERDIROP_REQUEST;
        break;
      default:
        enterdirmode=ENTERDIROP_ACTIVE;
        break;
    }
    chunksize-=Datei::getUCharSize();
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return 0;
}

void EnterDirOp::setMode(enterdir_t nv)
{
  enterdirmode=nv;
}

void EnterDirOp::setDir(const char* ndir)
{
  if(dir!=NULL) _freesafe(dir);
  dir=dupstring(ndir);
}

/*************
 Ende EnterDirOp
**************/

