/* searchentryop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: searchentryop.cc,v 1.5 2001/11/03 17:10:40 ralf Exp $ */

#include "searchentryop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *SearchEntryOp::name="SearchEntryOp";

SearchEntryOp::SearchEntryOp(Worker *tworker):FunctionProto(tworker)
{
}

SearchEntryOp::~SearchEntryOp()
{
}

SearchEntryOp*
SearchEntryOp::duplicate()
{
  SearchEntryOp *ta=new SearchEntryOp(worker);
  return ta;
}

bool
SearchEntryOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
SearchEntryOp::getName()
{
  return name;
}

int
SearchEntryOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodesearchentry();
    }
  }
  return 0;
}

const char *
SearchEntryOp::getDescription()
{
  return catalog.getLocaleCom(33);
}

int
SearchEntryOp::normalmodesearchentry()
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  
  if(startlister==NULL) return 1;
  lm1=startlister->getActiveMode();
  if(lm1==NULL) return 1;
  if(lm1->isType("NormalMode")!=true) return 1;
  nm1=(NormalMode*)lm1;
  
  nm1->searchentry();
  return 0;
}

