// $Id: WorldHelper.cpp,v 1.11 2003/03/13 23:36:16 zongo Exp $
#include "Main.h"
#include "WorldHelper.h"
#include "Application.h"

#include <Ark/ArkFileSys.h>

WorldHelper::WorldHelper () : 
    m_World(0)
{
}

WorldHelper::~WorldHelper ()
{
   delete m_World;
}

void
WorldHelper::Load(const std::string& name)
{
  if (m_World)
  {
    delete m_World;
  }

  g_Application->ClearCommands();
  
  Ark::Cache* cache = &g_Application->GetRenderer()->GetCache();
  cache->Clear();

  m_World = new World(cache);
  
  const bool loaded = m_World->LoadED(name);

  if (loaded) 
  {
    g_Application->GetTerrain()->SetWorld(m_World);
    g_Application->GetTerrain()->Center();
    g_Application->GetTerrain()->Update();
    
    //FIXME: Do I switch to browse mode ?
    //BrowseEnabled(1);
  }
  else
  {
    delete m_World;
    m_World = 0;
  }
  
}

void
WorldHelper::Write() const
{
  if (m_World) 
  {
     m_World->Write();
     //ClearCommands(); 
  }
}

void
WorldHelper::NewWorld (const std::string& path, 
		       const std::string& name,
		       int w, int h)
{
  Ark::Sys()->FS()->MakeDir(path.c_str(), 0755);

  Ark::String filename;
  Ark::String real;
  Ark::String arkpath = path;
  Ark::String::size_type start = path.find(Ark::Sys()->FS()->GetFileName("{game}"));
  if (start != Ark::String::npos)
    arkpath.replace(start, Ark::Sys()->FS()->GetFileName("{game}").size(), "{game}");
  
  filename = path + "/world.cfg";
  real = Ark::Sys()->FS()->GetFileName(filename);
  Ark::Sys()->Log("Writing %s (%s)\n", filename.c_str(), real.c_str());
  
  Ark::FileWriteStream* f;
  
  f = new Ark::FileWriteStream( real.c_str() );
  *f << "heightfield::Scale = 1.0;\n"
     << "heightfield::ScaleY = 0.2;\n"
     << "heightfield::HeightData = \"" << arkpath << "/elev.tga\";\n"
     << "heightfield::GroundData = \"" << arkpath << "/ground.tga\";\n"
     << "heightfield::NumGrounds = 1;\n"
     << "heightfield::Ground0 = \"{shaders}/ground-grass.mat\";\n"
     << "heightfield::Entities = \"" << arkpath << "/entities.lst\";\n\n"
     << "world::Callbacks = \"" << arkpath << "/callbacks.lst\";\n"
     << "world::Script = \"" << arkpath << "/quest.lua\";\n"
     << "world::Name = \"" << arkpath << "\";\n"
     << "sky::ToneMap = \"{shaders}/sky-tonemap.mat\";\n"
     << "sky::StarMap = \"{shaders}/sky-starmap.mat\";\n"
     << "sky::Size    = 500.0;\n"
     << "atmosphere::TimeOfDay = 0.53;\n"
     << "atmosphere::FogRed = 0.45;\n"
     << "atmosphere::FogGreen = 0.25;\n"
     << "atmosphere::FogBlue = 0.17;\n"
     << "atmosphere::FogDensity = 0.0098;\n";
  delete f;

  /////////////////////////////////////////
  filename = path + "/entities.lst";
  real = Ark::Sys()->FS()->GetFileName(filename);
  Ark::Sys()->Log("Writing %s (%s)\n", filename.c_str(), real.c_str());

  f = new Ark::FileWriteStream (filename.c_str());
  delete f;

  /////////////////////////////////////////
  filename = path + "/callbacks.lst";
  real = Ark::Sys()->FS()->GetFileName(filename);
  Ark::Sys()->Log("Writing %s (%s)\n", filename.c_str(), real.c_str());

  f = new Ark::FileWriteStream (filename.c_str());
  delete f;

  /////////////////////////////////////////
  filename = path + "/quest.lua";
  real = Ark::Sys()->FS()->GetFileName(filename);
  Ark::Sys()->Log("Writing %s (%s)\n", filename.c_str(), real.c_str());

  f = new Ark::FileWriteStream (filename.c_str());
  delete f;

  /////////////////////////////////////////
  filename = path + "/ground.tga";
  real = Ark::Sys()->FS()->GetFileName(filename);
  Ark::Sys()->Log("Writing %s (%s)\n", filename.c_str(), real.c_str());

  Ark::Image img("tmp", w, h, Ark::Image::I_8);
  img.SaveTGA(filename.c_str());

  /////////////////////////////////////////
  filename = path + "/elev.tga";
  real = Ark::Sys()->FS()->GetFileName(filename);
  Ark::Sys()->Log("Writing %s (%s)\n", filename.c_str(), real.c_str());

  memset(img.m_Data, 30, w * h);
  img.SaveTGA(filename.c_str());

  Load(path);
}

void 
WorldHelper::SetView(ViewWidget* view)
{
   // Load template ground
   // XXX should be non writable !
   Load("{world}/template");
}



////////////////////////////////////////////////////////////////////////////
// Wrapper functions around the World members
////////////////////////////////////////////////////////////////////////////

bool
WorldHelper::CanSave() const
{
   return (m_World != 0); 
}

bool
WorldHelper::IsChanged() const
{
   return m_World->IsChanged();
}

const std::string&
WorldHelper::GetFileName() const
{
   return m_World->GetFileName();
}

void
WorldHelper::SetFileName(const std::string& path)
{
   m_World->SetFileName(path);
}

World*
WorldHelper::GetWorld()
{
   return m_World;
}
