/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TableReader;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class TableFormatter
extends ConverterHelper {
    private boolean bApplyCellFormat;
    private TableReader table;
    private char[][] cAlign;
    private char[] cGlobalAlign;
    private boolean[][] bHBorder;
    private boolean[][] bVBorder;
    private boolean[] bGlobalVBorder;
    private String[] sRowColor;
    private String[][] sCellColor;
    private String[] sColumnWidth;
    private boolean bIsLongtable;
    private boolean bIsSupertabular;
    private boolean bIsTabulary;
    private boolean bIsColortbl;
    private boolean bIsSimple;

    public TableFormatter(OfficeReader ofr, Config config, ConverterPalette palette, TableReader table, boolean bAllowPageBreak, boolean bIsInTable) {
        super(ofr, config, palette);
        StyleWithProperties style;
        String sStyleName;
        int nCol;
        this.table = table;
        this.bApplyCellFormat = config.formatting() >= 3;
        int nRowCount = table.getRowCount();
        int nColCount = table.getColCount();
        int nSimpleTableLimit = config.getSimpleTableLimit();
        this.bIsSimple = true;
        this.cAlign = new char[nRowCount][nColCount];
        this.cGlobalAlign = new char[nColCount];
        int nRow = 0;
        while (nRow < nRowCount) {
            nCol = 0;
            while (nCol < nColCount) {
                Node cell = table.getCell(nRow, nCol);
                int nChars = OfficeReader.getCharacterCount(cell);
                if (OfficeReader.isSingleParagraph(cell) && nChars < nSimpleTableLimit) {
                    Element par = Misc.getChildByTagName(cell, "text:p");
                    StyleWithProperties style2 = ofr.getParStyle(Misc.getAttribute((Node)par, "text:style-name"));
                    this.cAlign[nRow][nCol] = 108;
                    if (style2 != null) {
                        String sAlign = style2.getProperty("fo:text-align", true);
                        if ("center".equals(sAlign)) {
                            this.cAlign[nRow][nCol] = 99;
                        } else if ("end".equals(sAlign)) {
                            this.cAlign[nRow][nCol] = 114;
                        }
                    }
                } else if (nChars > 0) {
                    this.bIsSimple = false;
                }
                ++nCol;
            }
            ++nRow;
        }
        nCol = 0;
        while (nCol < nColCount) {
            int nCenter = 0;
            int nRight = 0;
            int nRow2 = 0;
            while (nRow2 < nRowCount) {
                if (this.cAlign[nRow2][nCol] == 'c') {
                    ++nCenter;
                } else if (this.cAlign[nRow2][nCol] == 'r') {
                    ++nRight;
                }
                ++nRow2;
            }
            this.cGlobalAlign[nCol] = 108;
            int nLeft = nColCount - nCenter - nRight;
            if (nCenter > nLeft) {
                this.cGlobalAlign[nCol] = nRight > nLeft ? 114 : 99;
            } else if (nRight > nLeft) {
                this.cGlobalAlign[nCol] = 114;
            }
            ++nCol;
        }
        this.bHBorder = new boolean[nRowCount + 1][nColCount];
        int nRow3 = 0;
        while (nRow3 <= nRowCount) {
            int nCol2 = 0;
            while (nCol2 < nColCount) {
                this.bHBorder[nRow3][nCol2] = false;
                ++nCol2;
            }
            ++nRow3;
        }
        this.bVBorder = new boolean[nRowCount][nColCount + 1];
        int nRow4 = 0;
        while (nRow4 < nRowCount) {
            int nCol3 = 0;
            while (nCol3 <= nColCount) {
                this.bVBorder[nRow4][nCol3] = false;
                ++nCol3;
            }
            ++nRow4;
        }
        int nRow5 = 0;
        while (nRow5 < nRowCount) {
            int nCol4 = 0;
            while (nCol4 < nColCount) {
                Node cell = table.getCell(nRow5, nCol4);
                sStyleName = Misc.getAttribute(cell, "table:style-name");
                style = ofr.getCellStyle(sStyleName);
                int nColSpan = Misc.getPosInteger(Misc.getAttribute(cell, "table:number-columns-spanned"), 1);
                boolean bLeft = false;
                boolean bRight = false;
                boolean bTop = false;
                boolean bBottom = false;
                if (style != null) {
                    String sBorder = style.getProperty("fo:border");
                    if (sBorder != null && !"none".equals(sBorder)) {
                        bLeft = true;
                        bRight = true;
                        bTop = true;
                        bBottom = true;
                    }
                    if ((sBorder = style.getProperty("fo:border-left")) != null && !"none".equals(sBorder)) {
                        bLeft = true;
                    }
                    if ((sBorder = style.getProperty("fo:border-right")) != null && !"none".equals(sBorder)) {
                        bRight = true;
                    }
                    if ((sBorder = style.getProperty("fo:border-top")) != null && !"none".equals(sBorder)) {
                        bTop = true;
                    }
                    if ((sBorder = style.getProperty("fo:border-bottom")) != null && !"none".equals(sBorder)) {
                        bBottom = true;
                    }
                }
                boolean[] blArray = this.bVBorder[nRow5];
                int n = nCol4;
                blArray[n] = blArray[n] | bLeft;
                boolean[] blArray2 = this.bVBorder[nRow5];
                int n2 = nCol4 + nColSpan;
                blArray2[n2] = blArray2[n2] | bRight;
                do {
                    boolean[] blArray3 = this.bHBorder[nRow5];
                    int n3 = nCol4;
                    blArray3[n3] = blArray3[n3] | bTop;
                    boolean[] blArray4 = this.bHBorder[nRow5 + 1];
                    int n4 = nCol4++;
                    blArray4[n4] = blArray4[n4] | bBottom;
                } while (--nColSpan > 0);
            }
            ++nRow5;
        }
        this.bGlobalVBorder = new boolean[nColCount + 1];
        int nCol5 = 0;
        while (nCol5 <= nColCount) {
            int nBalance = 0;
            int nRow6 = 0;
            while (nRow6 < nRowCount) {
                nBalance += this.bVBorder[nRow6][nCol5] ? 1 : -1;
                ++nRow6;
            }
            this.bGlobalVBorder[nCol5] = nBalance > 0;
            ++nCol5;
        }
        this.sRowColor = new String[nRowCount];
        this.sCellColor = new String[nRowCount][nColCount];
        if (config.useColortbl()) {
            String sTableColor = null;
            StyleWithProperties tableStyle = ofr.getTableStyle(table.getTableStyleName());
            if (tableStyle != null) {
                sTableColor = tableStyle.getProperty("fo:background-color");
            }
            int nRow7 = 0;
            while (nRow7 < nRowCount) {
                StyleWithProperties rowStyle = ofr.getRowStyle(table.getRow(nRow7).getStyleName());
                if (rowStyle != null) {
                    this.sRowColor[nRow7] = rowStyle.getProperty("fo:background-color");
                }
                if (this.sRowColor[nRow7] == null) {
                    this.sRowColor[nRow7] = sTableColor;
                }
                if (this.sRowColor[nRow7] != null) {
                    this.bIsColortbl = true;
                }
                ++nRow7;
            }
            int nRow8 = 0;
            while (nRow8 < nRowCount) {
                int nCol6 = 0;
                while (nCol6 < nColCount) {
                    StyleWithProperties cellStyle = ofr.getCellStyle(Misc.getAttribute(table.getCell(nRow8, nCol6), "table:style-name"));
                    if (cellStyle != null) {
                        this.sCellColor[nRow8][nCol6] = cellStyle.getProperty("fo:background-color");
                        if (this.sCellColor[nRow8][nCol6] != null) {
                            this.bIsColortbl = true;
                            if (this.sCellColor[nRow8][nCol6].equals(this.sRowColor[nRow8])) {
                                this.sCellColor[nRow8][nCol6] = null;
                            }
                        }
                    }
                    ++nCol6;
                }
                ++nRow8;
            }
        }
        this.sColumnWidth = new String[nColCount];
        int nCol7 = 0;
        while (nCol7 < nColCount) {
            StyleWithProperties colStyle = ofr.getColumnStyle(table.getCol(nCol7).getStyleName());
            if (colStyle != null) {
                this.sColumnWidth[nCol7] = colStyle.getProperty("style:column-width");
            }
            if (this.sColumnWidth[nCol7] == null) {
                this.sColumnWidth[nCol7] = "2cm";
            }
            ++nCol7;
        }
        this.bIsLongtable = false;
        this.bIsSupertabular = false;
        this.bIsTabulary = false;
        if (!table.isSubTable() && !bIsInTable) {
            boolean bMayBreak;
            sStyleName = table.getTableStyleName();
            style = ofr.getTableStyle(sStyleName);
            boolean bl = bMayBreak = style == null || !"false".equals(style.getProperty("style:may-break-between-rows"));
            if (config.useLongtable() && bMayBreak && bAllowPageBreak) {
                this.bIsLongtable = true;
            } else if (config.useSupertabular() && bMayBreak && bAllowPageBreak) {
                this.bIsSupertabular = true;
            } else if (!this.bIsSimple && config.useTabulary()) {
                this.bIsTabulary = true;
            }
        }
    }

    public boolean isLongtable() {
        return this.bIsLongtable;
    }

    public boolean isSupertabular() {
        return this.bIsSupertabular;
    }

    public boolean isTabulary() {
        return this.bIsTabulary;
    }

    public boolean isColortbl() {
        return this.bIsColortbl;
    }

    public boolean isSimple() {
        return this.bIsSimple;
    }

    public void applyTableStyle(BeforeAfter ba, BeforeAfter baAlign) {
        String sStyleName = this.table.getTableStyleName();
        StyleWithProperties style = this.ofr.getTableStyle(sStyleName);
        char cAlign = 'c';
        if (style != null && !this.table.isSubTable()) {
            String s = style.getProperty("table:align");
            if ("left".equals(s)) {
                cAlign = 'l';
            } else if ("right".equals(s)) {
                cAlign = 'r';
            }
        }
        String sAlign = "center";
        switch (cAlign) {
            case 'c': {
                sAlign = "center";
                break;
            }
            case 'r': {
                sAlign = "flushright";
                break;
            }
            case 'l': {
                sAlign = "flushleft";
            }
        }
        if (!this.bIsLongtable && !this.table.isSubTable()) {
            baAlign.add("\\begin{" + sAlign + "}\n", "\\end{" + sAlign + "}\n");
        }
        if (this.bIsLongtable) {
            ba.add("\\begin{longtable}[" + cAlign + "]", "\\end{longtable}");
        } else if (this.bIsSupertabular) {
            ba.add("\\begin{supertabular}", "\\end{supertabular}");
        } else if (this.bIsTabulary) {
            ba.add("\\begin{tabulary}{" + this.table.getTableWidth() + "}", "\\end{tabulary}");
        } else if (!this.table.isSubTable()) {
            ba.add("\\begin{tabular}", "\\end{tabular}");
        } else {
            ba.add("\\hspace*{-\\tabcolsep}\\begin{tabular}", "\\end{tabular}\\hspace*{-\\tabcolsep}");
        }
        ba.add("{", "");
        if (this.bGlobalVBorder[0]) {
            ba.add("|", "");
        }
        int nColCount = this.table.getColCount();
        int nCol = 0;
        while (nCol < nColCount) {
            if (this.bIsSimple) {
                ba.add(Character.toString(this.cGlobalAlign[nCol]), "");
            } else if (!this.bIsTabulary) {
                ba.add("m{" + Misc.add(this.sColumnWidth[nCol], "-0.2cm") + "}", "");
            } else {
                ba.add("J", "");
            }
            if (this.bGlobalVBorder[nCol + 1]) {
                ba.add("|", "");
            }
            ++nCol;
        }
        ba.add("}", "");
    }

    public String getInterrowMaterial(int nRow) {
        int nColCount = this.table.getColCount();
        int nCount = 0;
        int nCol = 0;
        while (nCol < nColCount) {
            if (this.bHBorder[nRow][nCol]) {
                ++nCount;
            }
            ++nCol;
        }
        if (nCount == 0) {
            return "";
        }
        if (nCount == nColCount) {
            return "\\hline";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("\\hhline{");
        int nCol2 = 0;
        while (nCol2 < nColCount) {
            if (this.bHBorder[nRow][nCol2]) {
                buf.append("-");
            } else {
                buf.append("~");
            }
            ++nCol2;
        }
        buf.append("}");
        return buf.toString();
    }

    public void applyRowStyle(int nRow, BeforeAfter ba, Context context) {
        this.palette.getColorCv().applyBgColor("\\rowcolor", this.sRowColor[nRow], ba, context);
    }

    public void applyCellStyle(int nRow, int nCol, BeforeAfter ba, Context context) {
        Node cell = this.table.getCell(nRow, nCol);
        int nColSpan = Misc.getPosInteger(Misc.getAttribute(cell, "table:number-columns-spanned"), 1);
        boolean bNeedLeft = nCol == 0 && this.bVBorder[nRow][0] != this.bGlobalVBorder[0];
        boolean bNeedRight = this.bVBorder[nRow][nCol + 1] != this.bGlobalVBorder[nCol + 1];
        boolean bNeedAlign = this.bIsSimple && this.cGlobalAlign[nCol] != this.cAlign[nRow][nCol];
        String sTotalColumnWidth = this.sColumnWidth[nCol];
        int i = nCol + 1;
        while (i < nCol + nColSpan) {
            sTotalColumnWidth = Misc.add(sTotalColumnWidth, this.sColumnWidth[i]);
            ++i;
        }
        sTotalColumnWidth = Misc.add(sTotalColumnWidth, "-0.2cm");
        if (bNeedAlign || bNeedLeft || bNeedRight || nColSpan > 1) {
            ba.add("\\multicolumn{" + nColSpan + "}{", "");
            if (nCol == 0 && this.bVBorder[nRow][0]) {
                ba.add("|", "");
            }
            if (this.bIsSimple) {
                ba.add(Character.toString(this.cAlign[nRow][nCol]), "");
            } else {
                ba.add("m{" + sTotalColumnWidth + "}", "");
            }
            if (this.bVBorder[nRow][nCol + nColSpan]) {
                ba.add("|", "");
            }
            ba.add("}{", "}");
        }
        this.palette.getColorCv().applyBgColor("\\cellcolor", this.sCellColor[nRow][nCol], ba, context);
    }
}

