/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Enumeration;
import writer2latex.office.MasterPage;
import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.PageLayout;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.StyleConverterHelper;
import writer2latex.xhtml.StyleInfo;

public class PageStyleConverter
extends StyleConverterHelper {
    public PageStyleConverter(OfficeReader ofr, Config config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
    }

    public void applyStyle(String sStyleName, StyleInfo info) {
        MasterPage masterPage = this.ofr.getMasterPage(sStyleName);
        String sDisplayName = masterPage.getDisplayName();
        if (masterPage != null) {
            if (this.ofr.isPresentation()) {
                info.sClass = "masterpage" + this.styleNames.getExportName(sDisplayName);
            } else {
                String sPageLayout = masterPage.getPageLayoutName();
                PageLayout pageLayout = this.ofr.getPageLayout(sPageLayout);
                if (pageLayout != null) {
                    StyleConverterHelper.applyDirection(pageLayout, info);
                    if (this.bConvertStyles) {
                        this.getFrameSc().cssBackground(pageLayout, info.props, true);
                    }
                }
            }
        }
    }

    public String getStyleDeclarations(String sIndent) {
        StringBuffer buf = new StringBuffer();
        Enumeration names = this.styleNames.keys();
        while (names.hasMoreElements()) {
            StyleWithProperties drawingPage;
            String sDisplayName = (String)names.nextElement();
            MasterPage style = (MasterPage)this.getStyles().getStyleByDisplayName(sDisplayName);
            StyleInfo info = new StyleInfo();
            PageLayout pageLayout = this.ofr.getPageLayout(style.getPageLayoutName());
            if (pageLayout != null) {
                StyleConverterHelper.applyDirection(pageLayout, info);
                this.cssPageSize(pageLayout, info.props);
                this.getFrameSc().cssBackground(pageLayout, info.props, true);
            }
            if ((drawingPage = this.ofr.getDrawingPageStyle(style.getProperty("draw:style-name"))) != null) {
                this.cssDrawBackground(drawingPage, info.props, true);
            }
            buf.append(sIndent).append(".masterpage").append(this.styleNames.getExportName(sDisplayName)).append(" {").append(info.props.toString()).append("}\n");
        }
        return buf.toString();
    }

    public OfficeStyleFamily getStyles() {
        return this.ofr.getMasterPages();
    }

    private void cssDrawBackground(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getProperty("draw:fill-color", bInherit);
        if (s != null) {
            props.addValue("background-color", s);
        }
    }

    private void cssPageSize(PageLayout style, CSVList props) {
        String sHeight;
        String sWidth = style.getProperty("fo:page-width");
        if (sWidth != null) {
            props.addValue("width", this.scale(sWidth));
        }
        if ((sHeight = style.getProperty("fo:page-height")) != null) {
            props.addValue("height", this.scale(sHeight));
        }
    }
}

