/***************************************
  $Header: /home/amb/wwwoffle/RCS/htdig.c 1.10 1999/09/06 18:15:42 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.5.
  Handle the interface to the htdig search engine.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98,99 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <time.h>
#include <utime.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/wait.h>

#include "wwwoffle.h"
#include "misc.h"
#include "proto.h"
#include "errors.h"


static void HTDigIndex(int fd,URL *Url);
static void HTDigIndexRoot(int fd);
static void HTDigIndexProtocol(int fd,char *proto);
static void HTDigIndexHost(int fd,char *proto,char *host);
static void HTDigIndexLastTime(int fd);

static int HTSearch(int fd,char *args);


/*++++++++++++++++++++++++++++++++++++++
  Create a page for one of the htdig pages on the local server.

  int fd The file descriptor to write the output to.

  URL *Url The URL that specifies the path to generate the index for.

  Header *head The head of the request.
  ++++++++++++++++++++++++++++++++++++++*/

void HTDigPage(int fd,URL *Url,Header *head)
{

 if(!strncmp(Url->path+7,"index/",5))
    HTDigIndex(fd,Url);
 else if(!strcmp(Url->path+7,"htsearch"))
   {
    if(HTSearch(fd,Url->args))
       HTMLMessage(fd,500,"WWWOFFLE Server Error",NULL,"ServerError",
                   "error","Problem running htsearch program.",
                   NULL);
   }
 else if(!strchr(Url->path+7,'/'))
    LocalPage(fd,Url->path,head);
 else
    HTMLMessage(fd,404,"WWWOFFLE Page Not Found",NULL,"PageNotFound",
                "url",Url->name,
                NULL);
}


/*++++++++++++++++++++++++++++++++++++++
  Produce one of the indexes for htdig to search.

  int fd The file descriptor to write to.

  URL *Url The URL that was requested.
  ++++++++++++++++++++++++++++++++++++++*/

static void HTDigIndex(int fd,URL *Url)
{
 char *proto=(char*)malloc(strlen(Url->path)-10),*host="";
 int lasttime;
 int i;

 strcpy(proto,Url->path+13);

 lasttime=!strcmp(proto,"lasttime");

 if(*proto && proto[strlen(proto)-1]=='/')
    proto[strlen(proto)-1]=0;

 for(i=0;proto[i];i++)
    if(proto[i]=='/')
      {
       proto[i]=0;
       host=proto+i+1;
       break;
      }

 if(*proto)
   {
    for(i=0;i<NProtocols;i++)
       if(!strcmp(Protocols[i].name,proto))
          break;
    if(i==NProtocols)
       *proto=0;
   }

 if(!lasttime &&
    ((*host && (strchr(host,'/') || !strcmp(host,"..") || !strcmp(host,"."))) ||
     (*proto && (!strcmp(host,"..") || !strcmp(host,".")))||
     (*host && !*proto) || (Url->path[13] && !*proto)))
    HTMLMessage(fd,404,"WWWOFFLE Page Not Found",NULL,"PageNotFound",
                "url",Url->name,
                NULL);
 else
   {
    HTMLMessageHead(fd,200,"WWWOFFLE HTDig Index",
                    NULL);
    write_string(fd,"<html>\n"
                    "<head>\n"
                    "<title></title>\n"
                    "</head>\n"
                    "<body>\n");

    if(lasttime)
       HTDigIndexLastTime(fd);
    else if(!*host && !*proto)
       HTDigIndexRoot(fd);
    else if(!*host)
       HTDigIndexProtocol(fd,proto);
    else
       HTDigIndexHost(fd,proto,host);

    write_string(fd,"</body>\n"
                    "</html>\n");
   }

 free(proto);
}


/*++++++++++++++++++++++++++++++++++++++
  Index the root of the cache.

  int fd The file descriptor to write to.
  ++++++++++++++++++++++++++++++++++++++*/

static void HTDigIndexRoot(int fd)
{
 int i;

 for(i=0;i<NProtocols;i++)
    write_formatted(fd,"<a href=\"%s/\"> </a>\n",Protocols[i].name);
}


/*++++++++++++++++++++++++++++++++++++++
  Index the hosts for one protocol in the cache.

  int fd The file descriptor to write to.

  char *proto The protocol to index.
  ++++++++++++++++++++++++++++++++++++++*/

static void HTDigIndexProtocol(int fd,char *proto)
{
 DIR *dir;
 struct dirent* ent;
 struct stat buf;

 /* Open the spool directory. */

 if(chdir(proto))
    return;

 dir=opendir(".");
 if(!dir)
   {chdir("..");return;}

 ent=readdir(dir);  /* skip .  */
 if(!ent)
   {closedir(dir);chdir("..");return;}
 ent=readdir(dir);  /* skip .. */

 /* Output all of the host sub-directories. */

 while((ent=readdir(dir)))
    if(!stat(ent->d_name,&buf) && S_ISDIR(buf.st_mode))
      {
#if defined(__CYGWIN__)
       if(strchr(ent->d_name,'!'))
         {
          char *bang=strchr(ent->d_name,'!');
          *bang=':';
         }
#endif

       write_formatted(fd,"<a href=\"%s/\"> </a>\n",ent->d_name);
      }

 closedir(dir);

 chdir("..");
}


/*++++++++++++++++++++++++++++++++++++++
  Create an index of the pages on a host.

  int fd The file descriptor to write to.

  char *proto The protocol to index.

  char *host The name of the subdirectory.
  ++++++++++++++++++++++++++++++++++++++*/

static void HTDigIndexHost(int fd,char *proto,char *host)
{
 DIR *dir;
 struct dirent* ent;
 char *url;

 /* Open the spool subdirectory. */

 if(chdir(proto))
    return;

 /* Open the spool subdirectory. */

#if defined(__CYGWIN__)
 if(strchr(host,':'))
   {
    char *colon=strchr(host,':');
    *colon='!';
   }
#endif

 if(chdir(host))
   {chdir("..");return;}

 dir=opendir(".");
 if(!dir)
   {chdir("../..");return;}

 ent=readdir(dir);  /* skip .  */
 if(!ent)
   {closedir(dir);chdir("../..");return;}
 ent=readdir(dir);  /* skip .. */

 /* Output all of the file names. */

 while((ent=readdir(dir)))
    if(*ent->d_name=='D' && (url=FileNameToURL(ent->d_name)))
      {
       URL *Url=SplitURL(url);

       if(Url->Protocol->number==Protocol_HTTP)
          write_formatted(fd,"<a href=\"%s\"> </a>\n",Url->name);
       else
          write_formatted(fd,"<a href=\"/%s/%s\"> </a>\n",Url->proto,Url->hostp);

       FreeURL(Url);
       free(url);
      }

 closedir(dir);

 chdir("../..");
}


/*++++++++++++++++++++++++++++++++++++++
  Create an index of the lasttime accessed pages.

  int fd The file descriptor to write to.
  ++++++++++++++++++++++++++++++++++++++*/

static void HTDigIndexLastTime(int fd)
{
 DIR *dir;
 struct dirent* ent;
 char *url;

 /* Open the spool subdirectory. */

 if(chdir("lasttime"))
    return;

 dir=opendir(".");
 if(!dir)
   {chdir("..");return;}

 ent=readdir(dir);  /* skip .  */
 if(!ent)
   {closedir(dir);chdir("..");return;}
 ent=readdir(dir);  /* skip .. */

 /* Output all of the file names. */

 while((ent=readdir(dir)))
    if(*ent->d_name=='D' && (url=FileNameToURL(ent->d_name)))
      {
       URL *Url=SplitURL(url);

       if(Url->Protocol->number==Protocol_HTTP)
          write_formatted(fd,"<a href=\"%s\"> </a>\n",Url->name);
       else
          write_formatted(fd,"<a href=\"/%s/%s\"> </a>\n",Url->proto,Url->hostp);

       FreeURL(Url);
       free(url);
      }

 closedir(dir);

 chdir("..");
}


/*++++++++++++++++++++++++++++++++++++++
  Perform a search using the data from the posted form.

  int HTSearch Returns 1 in case of error.

  int fd The file descriptor to write to.

  char *args The arguments of the request.
  ++++++++++++++++++++++++++++++++++++++*/

static int HTSearch(int fd,char *args)
{
 pid_t pid;

 if((pid=fork())==-1)
   {PrintMessage(Warning,"Cannot fork to call htsearch [%!s].");return(1);}
 else if(pid)
   {
    int status;

    wait(&status);

    if(!WIFEXITED(status))
       return(1);
   }
 else
   {
    char *query=(char*)malloc(strlen(args)+16);

    if(fd!=1)
      {
       close(1);
       dup(fd);
       close(fd);
      }

    write_string(1,"HTTP/1.0 200 htsearch output\r\n");

    putenv("REQUEST_METHOD=GET");
    sprintf(query,"QUERY_STRING=%s",args);
    putenv(query);
    putenv("SCRIPT_NAME=htsearch");
    execl("html/htdig/scripts/wwwoffle-htsearch","html/htdig/scripts/wwwoffle-htsearch",NULL);
    PrintMessage(Warning,"Cannot exec html/htdig/scripts/wwwoffle-htsearch. [%!s]");
    exit(1);
   }

 return(0);
}
