#! /bin/sh

### BEGIN INIT INFO
# Provides:          wzdftpd
# Required-Start:    $syslog
# Required-Stop:     $syslog
# Should-Start:      $local_fs
# Should-Stop:       $local_fs
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Control script for wzdftpd
# Description:       Init script to control (start/stop/reload)
#                    the wzdftpd FTP server.
### END INIT INFO

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/wzdftpd
NAME=wzdftpd
DESC=wzdftpd

test -x $DAEMON || exit 0

# Include wzdftpd defaults if available
if [ -f /etc/default/wzdftpd ] ; then
	. /etc/default/wzdftpd
fi

if [ -n "$CONFIG" ]; then
  DAEMON_OPTS="$DAEMON_OPTS -f $CONFIG"
fi

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: "
	start-stop-daemon --start --quiet \
		--pidfile /var/run/$NAME/$NAME.pid --exec $DAEMON -- $DAEMON_OPTS
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	start-stop-daemon --stop --quiet --oknodo --pidfile /var/run/$NAME/$NAME.pid
	echo "$NAME."
	;;
  reload)
	#
	#	If the daemon can reload its config files on the fly
	#	for example by sending it SIGHUP, do it here.
	#
	#	If the daemon responds to changes in its config file
	#	directly anyway, make this a do-nothing entry.
	#
	echo "Reloading $DESC configuration files."
	start-stop-daemon --stop --signal 1 --quiet --pidfile \
		/var/run/$NAME.pid --exec $DAEMON
  	;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	echo -n "Restarting $DESC: "
	start-stop-daemon --stop --quiet --oknodo --pidfile /var/run/$NAME/$NAME.pid
	sleep 3
	start-stop-daemon --start --quiet \
		--pidfile /var/run/$NAME/$NAME.pid --exec $DAEMON -- $DAEMON_OPTS
	echo "$NAME."
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
