/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Binding;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import java.util.Vector;
import org.xml.sax.SAXException;

public class Bindery {
    private static StringValue busyValue = new StringValue("busy");
    private Object[] globals;
    private boolean[] busy;
    private Vector stack = new Vector(20);
    private Object[] currentStackFrame;
    private ParameterSet globalParameters;
    private int top = -1;
    private int allocated = 0;
    private int globalSpace = 0;
    private int localSpace = 0;

    public void allocateGlobals(int n) {
        this.globalSpace = n;
        this.globals = new Object[n];
        this.busy = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.globals[n2] = null;
            this.busy[n2] = false;
            ++n2;
        }
    }

    public void defineGlobalParameters(ParameterSet parameterSet) throws SAXException {
        this.globalParameters = parameterSet;
    }

    public boolean useGlobalParameter(String string, Binding binding) throws SAXException {
        if (this.globalParameters == null) {
            return false;
        }
        Value value = this.globalParameters.get(string);
        if (value == null) {
            return false;
        }
        this.globals[binding.getSlotNumber()] = value;
        return true;
    }

    public void defineGlobalVariable(Binding binding, Value value) throws SAXException {
        this.globals[binding.getSlotNumber()] = value;
    }

    public void setExecuting(Binding binding, boolean bl) throws SAXException {
        int n = binding.getSlotNumber();
        if (bl) {
            if (this.busy[n]) {
                throw new SAXException("Circular definition of variable " + binding.getVariableName());
            }
            this.busy[n] = true;
        } else {
            this.busy[n] = false;
        }
    }

    public boolean isEvaluated(Binding binding) {
        return this.globals[binding.getSlotNumber()] != null;
    }

    public void allocateLocals(int n) {
        if (n > this.localSpace) {
            this.localSpace = n;
        }
    }

    public void openStackFrame(ParameterSet parameterSet) {
        if (++this.top >= this.allocated) {
            this.currentStackFrame = new Object[this.localSpace + 1];
            this.stack.addElement(this.currentStackFrame);
            ++this.allocated;
        } else {
            this.currentStackFrame = (Object[])this.stack.elementAt(this.top);
        }
        this.currentStackFrame[0] = parameterSet;
        int n = 1;
        while (n < this.currentStackFrame.length) {
            this.currentStackFrame[n] = null;
            ++n;
        }
    }

    public void closeStackFrame() {
        --this.top;
        this.currentStackFrame = this.top < 0 ? null : (Object[])this.stack.elementAt(this.top);
    }

    public boolean useLocalParameter(String string, Binding binding) throws SAXException {
        ParameterSet parameterSet = (ParameterSet)this.currentStackFrame[0];
        if (parameterSet == null) {
            return false;
        }
        Value value = parameterSet.get(string);
        this.currentStackFrame[binding.getSlotNumber() + 1] = value;
        return value != null;
    }

    public Value getLocalParameter(String string) throws SAXException {
        ParameterSet parameterSet = (ParameterSet)this.currentStackFrame[0];
        if (parameterSet == null) {
            return null;
        }
        return parameterSet.get(string.intern());
    }

    public void defineLocalVariable(Binding binding, Value value) throws SAXException {
        if (this.currentStackFrame == null) {
            throw new SAXException("Can't define local variable: stack is empty");
        }
        this.currentStackFrame[binding.getSlotNumber() + 1] = value;
    }

    public Value getValue(Binding binding) throws SAXException {
        if (binding.isGlobal()) {
            return (Value)this.globals[binding.getSlotNumber()];
        }
        if (this.currentStackFrame != null) {
            return (Value)this.currentStackFrame[binding.getSlotNumber() + 1];
        }
        return null;
    }

    public Value getValue(Binding binding, int n) throws SAXException {
        if (binding.isGlobal()) {
            return (Value)this.globals[binding.getSlotNumber()];
        }
        Object[] objectArray = (Object[])this.stack.elementAt(n);
        if (objectArray != null) {
            return (Value)objectArray[binding.getSlotNumber() + 1];
        }
        return null;
    }

    public int getFrameId() {
        return this.top;
    }

    public void assignVariable(Binding binding, Value value) throws SAXException {
        if (binding.isGlobal()) {
            this.defineGlobalVariable(binding, value);
        } else {
            this.defineLocalVariable(binding, value);
        }
    }
}

