/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.om;

import com.icl.saxon.NameTest;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.NodeInfo;
import org.xml.sax.SAXException;

public class Name
implements NameTest {
    public static final char SEPARATOR = '^';
    private String absoluteName;
    private String displayName;
    private short hash = (short)-1;

    public Name() {
    }

    public Name(String string, String string2, String string3) throws SAXException {
        if (!Name.isNCName(string3)) {
            throw new SAXException("Invalid local name: \"" + string3 + "\" (prefix=" + string + ", uri=" + string2 + ")");
        }
        if (string == "") {
            this.displayName = string3;
        } else {
            if (!Name.isNCName(string)) {
                throw new SAXException("Invalid character in name prefix: " + string3);
            }
            this.displayName = (string + ':' + string3).intern();
        }
        this.absoluteName = string2 == "" ? string3.intern() : (string2 + '^' + string3).intern();
    }

    public Name(String string, ElementInfo elementInfo, boolean bl) throws SAXException {
        int n = string.indexOf(":");
        if (n < 0) {
            String string2 = "";
            this.displayName = string.intern();
            if (!Name.isNCName(string)) {
                throw new SAXException("Name " + string + " contains invalid characters");
            }
            String string3 = bl ? elementInfo.getURIforPrefix(string2).intern() : "";
            this.absoluteName = string3 == "" ? this.displayName.intern() : (string3 + '^' + string).intern();
        } else {
            if (n == 0) {
                throw new SAXException("Name " + string + " cannot start with a colon");
            }
            if (n == string.length() - 1) {
                throw new SAXException("Name " + string + " cannot end with a colon");
            }
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + 1).intern();
            if (!Name.isNCName(string4) || !Name.isNCName(string5)) {
                throw new SAXException("Name " + string + " contains invalid characters");
            }
            String string6 = elementInfo.getURIforPrefix(string4).intern();
            this.displayName = string.intern();
            this.absoluteName = string6 == "" ? string5.intern() : (string6 + '^' + string5).intern();
        }
    }

    public Name(String string) {
        this.displayName = string.intern();
        this.absoluteName = this.displayName.intern();
    }

    public static Name reconstruct(String string, String string2, String string3) {
        Name name = new Name();
        if (string == "") {
            name.absoluteName = string3.intern();
            name.displayName = string3;
        } else {
            name.absoluteName = (string2 + '^' + string3).intern();
            name.displayName = (string + ':' + string3).intern();
        }
        return name;
    }

    public final String getPrefix() {
        int n = this.displayName.indexOf(":");
        if (n < 0) {
            return "";
        }
        return this.displayName.substring(0, n).intern();
    }

    public final String getURI() {
        int n = this.absoluteName.indexOf(94);
        if (n < 0) {
            return "";
        }
        return this.absoluteName.substring(0, n).intern();
    }

    public final String getLocalName() {
        int n = this.displayName.indexOf(":");
        if (n < 0) {
            return this.displayName;
        }
        return this.displayName.substring(n + 1).intern();
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final String getAbsoluteName() {
        return this.absoluteName;
    }

    public short getHashCode() {
        if (this.hash != -1) {
            return this.hash;
        }
        int n = 0;
        int n2 = this.absoluteName.length();
        if (n2 > 8) {
            n = n2 - 8;
        }
        int n3 = n2;
        int n4 = n;
        while (n4 < n2) {
            n3 += this.absoluteName.charAt(n4);
            ++n4;
        }
        this.hash = (short)(n3 & Short.MAX_VALUE);
        return this.hash;
    }

    public final String toString() {
        return this.displayName;
    }

    public final boolean equals(Name name) {
        return this.absoluteName == name.absoluteName;
    }

    public static String getLocalPartOfAbsoluteName(String string) {
        int n = string.indexOf(94);
        if (n >= 0) {
            return string.substring(n + 1).intern();
        }
        return string;
    }

    public static String getURIPartOfAbsoluteName(String string) {
        int n = string.indexOf(94);
        if (n > 0) {
            return string.substring(0, n).intern();
        }
        return "";
    }

    public static boolean isNCName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c != '_' && !Character.isLetter(c)) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (c2 != '_' && c2 != '.' && c2 != '-' && !Character.isLetter(c2) && !Character.isDigit(c2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isQName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return Name.isNCName(string);
        }
        if (n == 0 || n == string.length() - 1) {
            return false;
        }
        if (!Name.isNCName(string.substring(0, n))) {
            return false;
        }
        return Name.isNCName(string.substring(n + 1));
    }

    public final boolean isNameOf(NodeInfo nodeInfo) throws SAXException {
        Name name = nodeInfo.getExpandedName();
        if (name == null) {
            return false;
        }
        return this.absoluteName == name.absoluteName;
    }

    public double getDefaultPriority() {
        return 0.0;
    }
}

