/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.EmbeddedStyleSheet;
import com.icl.saxon.KeyManager;
import com.icl.saxon.PIGrabber;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.ProcInstInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.tree.BaseURIMap;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.LineNumberMap;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.ParentNodeImpl;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DocumentImpl
extends ParentNodeImpl
implements DocumentInfo,
Document,
DOMImplementation {
    private static int nextDocumentNumber = 0;
    private static int nextSequenceNumber = 0;
    private ElementInfo documentElement;
    private Hashtable idTable = null;
    private int documentNumber;
    private Hashtable entityTable = new Hashtable();
    private String systemId;
    private StringBuffer characterBuffer;
    private LineNumberMap lineNumberMap;
    private BaseURIMap baseURIMap = new BaseURIMap();
    private Object[] index = new Object[30];
    private int indexEntriesUsed = 0;

    public DocumentImpl() {
        Boolean bl = Boolean.TRUE;
        synchronized (bl) {
            this.documentNumber = nextDocumentNumber++;
        }
        this.parent = null;
    }

    protected void setCharacterBuffer(StringBuffer stringBuffer) {
        this.characterBuffer = stringBuffer;
    }

    public final StringBuffer getCharacterBuffer() {
        return this.characterBuffer;
    }

    protected void setDocumentElement(ElementInfo elementInfo) {
        this.documentElement = elementInfo;
    }

    protected void setSystemId(String string) {
        if (string == null) {
            string = "*unknown.uri*";
        }
        this.baseURIMap.setBaseURI(this.sequence, string);
    }

    public String getSystemId() {
        return this.baseURIMap.getBaseURI(this.sequence);
    }

    protected void setBaseURI(int n, String string) {
        if (string == null) {
            string = "*unknown.uri*";
        }
        this.baseURIMap.setBaseURI(n, string);
    }

    protected String getBaseURI(int n) {
        return this.baseURIMap.getBaseURI(n);
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(this.sequence, 0);
    }

    protected void setLineNumber(int n, int n2) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(n, n2);
        }
    }

    protected int getLineNumber(int n) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(n);
        }
        return -1;
    }

    public int getLineNumber() {
        return 0;
    }

    public final short getNodeType() {
        return 4;
    }

    public final Name getExpandedName() {
        return null;
    }

    public final String getNodeName() {
        return "#document";
    }

    public final Node getNextSibling() {
        return null;
    }

    public final Node getPreviousSibling() {
        return null;
    }

    public Element getDocumentElement() {
        return (ElementImpl)this.documentElement;
    }

    public DocumentInfo getDocumentRoot() {
        return this;
    }

    public int getNodeNumber(Pattern pattern) {
        return 1;
    }

    public int getNodeNumber() {
        return 1;
    }

    public int getNodeNumberAny(Pattern pattern) {
        return 1;
    }

    public String getSequentialKey() {
        return NodeImpl.alphaKey(this.documentNumber);
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    private void indexIDs() throws SAXException {
        NodeInfo nodeInfo;
        if (this.idTable != null) {
            return;
        }
        this.idTable = new Hashtable();
        DocumentImpl documentImpl = nodeInfo = this;
        while (nodeInfo != null) {
            if (nodeInfo instanceof ElementInfo) {
                ElementInfo elementInfo = (ElementInfo)nodeInfo;
                AttributeCollection attributeCollection = elementInfo.getAttributeList();
                int n = 0;
                while (n < attributeCollection.getLength()) {
                    if (attributeCollection.getType(n).equals("ID")) {
                        this.registerID(elementInfo, attributeCollection.getValue(n));
                    }
                    ++n;
                }
            }
            nodeInfo = nodeInfo.getNextInDocument(documentImpl);
        }
    }

    private void registerID(ElementInfo elementInfo, String string) throws SAXException {
        ElementInfo elementInfo2 = (ElementInfo)this.idTable.get(string);
        if (elementInfo2 == null) {
            this.idTable.put(string, elementInfo);
        }
    }

    public ElementInfo selectID(String string) throws SAXException {
        if (this.idTable == null) {
            this.indexIDs();
        }
        return (ElementInfo)this.idTable.get(string);
    }

    public synchronized Hashtable getKeyIndex(KeyManager keyManager, String string) throws SAXException {
        int n = 0;
        while (n < this.indexEntriesUsed) {
            if ((KeyManager)this.index[n] == keyManager && ((String)this.index[n + 1]).equals(string)) {
                Object object = this.index[n + 2];
                if (object instanceof Hashtable) {
                    return (Hashtable)this.index[n + 2];
                }
                throw new SAXException("Circular reference to key definition");
            }
            n += 3;
        }
        return null;
    }

    public synchronized void setKeyIndex(KeyManager keyManager, String string, Object object) throws SAXException {
        int n = 0;
        while (n < this.indexEntriesUsed) {
            if ((KeyManager)this.index[n] == keyManager && ((String)this.index[n + 1]).equals(string)) {
                this.index[n + 2] = object;
                return;
            }
            n += 3;
        }
        if (this.indexEntriesUsed + 3 >= this.index.length) {
            Object[] objectArray = new Object[this.indexEntriesUsed * 2];
            System.arraycopy(this.index, 0, objectArray, 0, this.indexEntriesUsed);
            this.index = objectArray;
        }
        this.index[this.indexEntriesUsed++] = keyManager;
        this.index[this.indexEntriesUsed++] = string;
        this.index[this.indexEntriesUsed++] = object;
    }

    protected void setUnparsedEntity(String string, String string2) {
        this.entityTable.put(string, string2);
    }

    public String getUnparsedEntity(String string) {
        String string2 = (String)this.entityTable.get(string);
        return string2 == null ? "" : string2;
    }

    public String[] getAssociatedStylesheets(String string, String string2) throws SAXException {
        PIGrabber pIGrabber = new PIGrabber();
        pIGrabber.setCriteria(string, string2, null);
        pIGrabber.setBaseURI(this.getSystemId());
        NodeInfo[] nodeInfoArray = this.getAllChildNodes();
        int n = 0;
        while (n < nodeInfoArray.length) {
            NodeInfo nodeInfo = nodeInfoArray[n];
            if (nodeInfo instanceof ProcInstInfo) {
                pIGrabber.processingInstruction(nodeInfo.getDisplayName(), nodeInfo.getValue());
            }
            if (nodeInfo instanceof ElementInfo) break;
            ++n;
        }
        return pIGrabber.getStylesheetURIs();
    }

    public PreparedStyleSheet getEmbeddedStylesheet(String string) throws SAXException {
        Name name = Name.reconstruct("xsl", "http://www.w3.org/1999/XSL/Transform", "stylesheet");
        Name name2 = Name.reconstruct("xsl", "http://www.w3.org/1999/XSL/Transform", "transform");
        NodeInfo nodeInfo = this;
        while (nodeInfo != null) {
            String string2 = nodeInfo.getAttributeValue("id");
            if (string2 != null && string2.equals(string) && (name.isNameOf(nodeInfo) || name2.isNameOf(nodeInfo))) {
                PreparedStyleSheet preparedStyleSheet = EmbeddedStyleSheet.build((ElementInfo)nodeInfo);
                return preparedStyleSheet;
            }
            nodeInfo = nodeInfo.getNextInDocument(this);
        }
        return null;
    }

    public void copy(Outputter outputter) throws SAXException {
        NodeInfo nodeInfo = (NodeInfo)this.getFirstChild();
        while (nodeInfo != null) {
            nodeInfo.copy(outputter);
            nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
        }
    }

    public String getPath() {
        return "/";
    }

    public String toString() {
        return "Document node";
    }

    public DocumentType getDoctype() {
        return null;
    }

    public DOMImplementation getImplementation() {
        return this;
    }

    public Element createElement(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public DocumentFragment createDocumentFragment() {
        return null;
    }

    public Text createTextNode(String string) {
        return null;
    }

    public Comment createComment(String string) {
        return null;
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        return null;
    }

    public Attr createAttribute(String string) throws DOMException {
        return null;
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public NodeList getElementsByTagName(String string) {
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        NodeInfo nodeInfo = this;
        while (nodeInfo != null) {
            if (nodeInfo instanceof ElementInfo && (string.equals("*") || string.equals(nodeInfo.getDisplayName()))) {
                vector.addElement(nodeInfo);
            }
            nodeInfo = nodeInfo.getNextInDocument(this);
        }
        return new NodeSetExtent(vector);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        return null;
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return null;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        NodeInfo nodeInfo = this;
        while (nodeInfo != null) {
            if (nodeInfo instanceof ElementInfo && (string.equals("*") || string.equals(nodeInfo.getURI()) && (string2.equals("*") || string2.equals(nodeInfo.getLocalName())))) {
                vector.addElement(nodeInfo);
            }
            nodeInfo = nodeInfo.getNextInDocument(this);
        }
        return new NodeSetExtent(vector);
    }

    public Element getElementById(String string) {
        try {
            return (ElementImpl)this.selectID(string);
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    public boolean hasFeature(String string, String string2) {
        return string.equalsIgnoreCase("xml");
    }

    public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
        this.disallowUpdate();
        return null;
    }
}

