/*
 * file shrinkdat.h - basic elements for shrink patterns
 *
 * $Id: shrinkdat.h,v 1.3 2004/05/14 10:00:35 alfie Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Revision 1.1  1999/06/20 19:54:03  xblast
 * Initial revision
 */
#ifndef _SHRINKDAT_H
#define _SHRINKDAT_H

/* Spiral and compound shrink data */

static shri_data spiral_shri_data[] = {
  /* Level 0 */
  {0,12,0,0},{0,11,1,0},{0,10,2,0},{0,9,3,0},{0,8,4,0},{0,7,5,0},
  {0,6,6,0},{0,5,7,0},{0,4,8,0},{0,3,9,0},{0,2,10,0},{0,1,11,0},
  {0,0,12,0},{1,0,13,0},{2,0,14,0},{3,0,15,0},{4,0,16,0},{5,0,17,0},
  {6,0,18,0},{7,0,19,0},{8,0,20,0},{9,0,21,0},{10,0,22,0},{11,0,23,0},
  {12,0,24,0},{13,0,25,0},{14,0,26,0},{14,1,27,0},{14,2,28,0},{14,3,29,0},
  {14,4,30,0},{14,5,31,0},{14,6,32,0},{14,7,33,0},{14,8,34,0},{14,9,35,0},
  {14,10,36,0},{14,11,37,0},{14,12,38,0},{13,12,39,0},{12,12,40,0},{11,12,41,0},
  {10,12,42,0},{9,12,43,0},{8,12,44,0},{7,12,45,0},{6,12,46,0},{5,12,47,0},
  {4,12,48,0},{3,12,49,0},{2,12,50,0},{1,12,51,0},
  /* Level 1 */
  {1,11,0,1},{1,10,1,1},{1,9,2,1},{1,8,3,1},{1,7,4,1},{1,6,5,1},
  {1,5,6,1},{1,4,7,1},{1,3,8,1},{1,2,9,1},{1,1,10,1},{2,1,11,1},
  {3,1,12,1},{4,1,13,1},{5,1,14,1},{6,1,15,1},{7,1,16,1},{8,1,17,1},
  {9,1,18,1},{10,1,19,1},{11,1,20,1},{12,1,21,1},{13,1,22,1},{13,2,23,1},
  {13,3,24,1},{13,4,25,1},{13,5,26,1},{13,6,27,1},{13,7,28,1},{13,8,29,1},
  {13,9,30,1},{13,10,31,1},{13,11,32,1},{12,11,33,1},{11,11,34,1},{10,11,35,1},
  {9,11,36,1},{8,11,37,1},{7,11,38,1},{6,11,39,1},{5,11,40,1},{4,11,41,1},
  {3,11,42,1},{2,11,43,1},
  /* Level 2 */
  {2,10,0,2},{2,9,1,2},{2,8,2,2},{2,7,3,2},{2,6,4,2},{2,5,5,2},
  {2,4,6,2},{2,3,7,2},{2,2,8,2},{3,2,9,2},{4,2,10,2},{5,2,11,2},
  {6,2,12,2},{7,2,13,2},{8,2,14,2},{9,2,15,2},{10,2,16,2},{11,2,17,2},
  {12,2,18,2},{12,3,19,2},{12,4,20,2},{12,5,21,2},{12,6,22,2},{12,7,23,2},
  {12,8,24,2},{12,9,25,2},{12,10,26,2},{11,10,27,2},{10,10,28,2},{9,10,29,2},
  {8,10,30,2},{7,10,31,2},{6,10,32,2},{5,10,33,2},{4,10,34,2},{3,10,35,2},
  /* Level 3 */
  {3,9,0,3},{3,8,1,3},{3,7,2,3},{3,6,3,3},{3,5,4,3},{3,4,5,3},
  {3,3,6,3},{4,3,7,3},{5,3,8,3},{6,3,9,3},{7,3,10,3},{8,3,11,3},
  {9,3,12,3},{10,3,13,3},{11,3,14,3},{11,4,15,3},{11,5,16,3},{11,6,17,3},
  {11,7,18,3},{11,8,19,3},{11,9,20,3},{10,9,21,3},{9,9,22,3},{8,9,23,3},
  {7,9,24,3},{6,9,25,3},{5,9,26,3},{4,9,27,3},
  /* Level 4 */
  {4,8,0,4},{4,7,1,4},{4,6,2,4},{4,5,3,4},{4,4,4,4},{5,4,5,4},
  {6,4,6,4},{7,4,7,4},{8,4,8,4},{9,4,9,4},{10,4,10,4},{10,5,11,4},
  {10,6,12,4},{10,7,13,4},{10,8,14,4},{9,8,15,4},{8,8,16,4},{7,8,17,4},
  {6,8,18,4},{5,8,19,4},
  /* Level 5 */
  {5,7,0,5},{5,6,1,5},{5,5,2,5},{6,5,3,5},{7,5,4,5},{8,5,5,5},
  {9,5,6,5},{9,6,7,5},{9,7,8,5},{8,7,9,5},{7,7,10,5},{6,7,11,5},
  /* Terminator */
  {-1,-1,-1,-1}
};
static shri_xoff_data spiral_xoff[] = { 
  0,52,96,132,160,180,-1 
};

/* Upward and downward shrink data */
static shri_data vertical_shri_data[] = {
  /* Level 0 */
  {0,0,7,0},{1,0,6,0},{2,0,5,0},{3,0,4,0},{4,0,3,0},{5,0,2,0},
  {6,0,1,0},{7,0,0,0},{8,0,1,0},{9,0,2,0},{10,0,3,0},{11,0,4,0},
  {12,0,5,0},{13,0,6,0},{14,0,7,0},
  /* Level 1 */
  {0,1,7,1},{1,1,6,1},{2,1,5,1},{3,1,4,1},{4,1,3,1},{5,1,2,1},
  {6,1,1,1},{7,1,0,1},{8,1,1,1},{9,1,2,1},{10,1,3,1},{11,1,4,1},
  {12,1,5,1},{13,1,6,1},{14,1,7,1},
  /* Level 2 */
  {0,2,7,2},{1,2,6,2},{2,2,5,2},{3,2,4,2},{4,2,3,2},{5,2,2,2},
  {6,2,1,2},{7,2,0,2},{8,2,1,2},{9,2,2,2},{10,2,3,2},{11,2,4,2},
  {12,2,5,2},{13,2,6,2},{14,2,7,2},
  /* Level 3 */
  {0,3,7,3},{1,3,6,3},{2,3,5,3},{3,3,4,3},{4,3,3,3},{5,3,2,3},
  {6,3,1,3},{7,3,0,3},{8,3,1,3},{9,3,2,3},{10,3,3,3},{11,3,4,3},
  {12,3,5,3},{13,3,6,3},{14,3,7,3},
  /* Level 4 */
  {0,4,7,4},{1,4,6,4},{2,4,5,4},{3,4,4,4},{4,4,3,4},{5,4,2,4},
  {6,4,1,4},{7,4,0,4},{8,4,1,4},{9,4,2,4},{10,4,3,4},{11,4,4,4},
  {12,4,5,4},{13,4,6,4},{14,4,7,4},
  /* Level 5 */
  {0,5,7,5},{1,5,6,5},{2,5,5,5},{3,5,4,5},{4,5,3,5},{5,5,2,5},
  {6,5,1,5},{7,5,0,5},{8,5,1,5},{9,5,2,5},{10,5,3,5},{11,5,4,5},
  {12,5,5,5},{13,5,6,5},{14,5,7,5},
  /* Level 6 */
  {0,6,7,6},{1,6,6,6},{2,6,5,6},{3,6,4,6},{4,6,3,6},{5,6,2,6},
  {6,6,1,6},{7,6,0,6},{8,6,1,6},{9,6,2,6},{10,6,3,6},{11,6,4,6},
  {12,6,5,6},{13,6,6,6},{14,6,7,6},
  /* Level 7 */
  {0,7,7,7},{1,7,6,7},{2,7,5,7},{3,7,4,7},{4,7,3,7},{5,7,2,7},
  {6,7,1,7},{7,7,0,7},{8,7,1,7},{9,7,2,7},{10,7,3,7},{11,7,4,7},
  {12,7,5,7},{13,7,6,7},{14,7,7,7},
  /* Level 8 */
  {0,8,7,8},{1,8,6,8},{2,8,5,8},{3,8,4,8},{4,8,3,8},{5,8,2,8},
  {6,8,1,8},{7,8,0,8},{8,8,1,8},{9,8,2,8},{10,8,3,8},{11,8,4,8},
  {12,8,5,8},{13,8,6,8},{14,8,7,8},
  /* Level 9 */
  {0,9,7,9},{1,9,6,9},{2,9,5,9},{3,9,4,9},{4,9,3,9},{5,9,2,9},
  {6,9,1,9},{7,9,0,9},{8,9,1,9},{9,9,2,9},{10,9,3,9},{11,9,4,9},
  {12,9,5,9},{13,9,6,9},{14,9,7,9},
  /* Level 10 */
  {0,10,7,10},{1,10,6,10},{2,10,5,10},{3,10,4,10},{4,10,3,10},{5,10,2,10},
  {6,10,1,10},{7,10,0,10},{8,10,1,10},{9,10,2,10},{10,10,3,10},{11,10,4,10},
  {12,10,5,10},{13,10,6,10},{14,10,7,10},
  /* Level 11 */
  {0,11,7,11},{1,11,6,11},{2,11,5,11},{3,11,4,11},{4,11,3,11},{5,11,2,11},
  {6,11,1,11},{7,11,0,11},{8,11,1,11},{9,11,2,11},{10,11,3,11},{11,11,4,11},
  {12,11,5,11},{13,11,6,11},{14,11,7,11},
  /* Level 12 */
  {0,12,7,12},{1,12,6,12},{2,12,5,12},{3,12,4,12},{4,12,3,12},{5,12,2,12},
  {6,12,1,12},{7,12,0,12},{8,12,1,12},{9,12,2,12},{10,12,3,12},{11,12,4,12},
  {12,12,5,12},{13,12,6,12},{14,12,7,12},
  /* Terminator */
  {-1,-1,-1,-1}
};
static shri_xoff_data vertical_xoff[] = { 
  0,8,16,24,32,40,48,56,64,72,80,88,96,-1 
};

/* Quad shrink data */
static shri_data quad_shri_data[] = {
  /* Level 0 */
  {0,0,6,0},{0,1,5,0},{0,2,4,0},{0,3,3,0},{0,4,2,0},{0,5,1,0},
  {0,6,0,0},{0,7,1,0},{0,8,2,0},{0,9,3,0},{0,10,4,0},{0,11,5,0},
  {0,12,6,0},
  {14,0,6,0},{14,1,5,0},{14,2,4,0},{14,3,3,0},{14,4,2,0},{14,5,1,0},
  {14,6,0,0},{14,7,1,0},{14,8,2,0},{14,9,3,0},{14,10,4,0},{14,11,5,0},
  {14,12,6,0},
  {1,0,6,0},{2,0,5,0},{3,0,4,0},{4,0,3,0},{5,0,2,0},{6,0,1,0},
  {7,0,0,0},{8,0,1,0},{9,0,2,0},{10,0,3,0},{11,0,4,0},{12,0,5,0},
  {13,0,6,0},
  {1,12,6,0},{2,12,5,0},{3,12,4,0},{4,12,3,0},{5,12,2,0},{6,12,1,0},
  {7,12,0,0},{8,12,1,0},{9,12,2,0},{10,12,3,0},{11,12,4,0},{12,12,5,0},
  {13,12,6,0},
  /* Level 1 */
  {1,1,5,1},{1,2,4,1},{1,3,3,1},{1,4,2,1},{1,5,1,1},{1,6,0,1},
  {1,7,1,1},{1,8,2,1},{1,9,3,1},{1,10,4,1},{1,11,5,1},
  {13,1,5,1},{13,2,4,1},{13,3,3,1},{13,4,2,1},{13,5,1,1},{13,6,0,1},
  {13,7,1,1},{13,8,2,1},{13,9,3,1},{13,10,4,1},{13,11,5,1},
  {2,1,5,1},{3,1,4,1},{4,1,3,1},{5,1,2,1},{6,1,1,1},{7,1,0,1},
  {8,1,1,1},{9,1,2,1},{10,1,3,1},{11,1,4,1},{12,1,5,1},
  {2,11,5,1},{3,11,4,1},{4,11,3,1},{5,11,2,1},{6,11,1,1},{7,11,0,1},
  {8,11,1,1},{9,11,2,1},{10,11,3,1},{11,11,4,1},{12,11,5,1},
  /* Level 2 */
  {2,2,4,2},{2,3,3,2},{2,4,2,2},{2,5,1,2},{2,6,0,2},{2,7,1,2},
  {2,8,2,2},{2,9,3,2},{2,10,4,2},
  {12,2,4,2},{12,3,3,2},{12,4,2,2},{12,5,1,2},{12,6,0,2},{12,7,1,2},
  {12,8,2,2},{12,9,3,2},{12,10,4,2},
  {3,2,4,2},{4,2,3,2},{5,2,2,2},{6,2,1,2},{7,2,0,2},{8,2,1,2},
  {9,2,2,2},{10,2,3,2},{11,2,4,2},
  {3,10,4,2},{4,10,3,2},{5,10,2,2},{6,10,1,2},{7,10,0,2},{8,10,1,2},
  {9,10,2,2},{10,10,3,2},{11,10,4,2},
  /* Level 3 */
  {3,3,3,3},{3,4,2,3},{3,5,1,3},{3,6,0,3},{3,7,1,3},{3,8,2,3},
  {3,9,3,3},
  {11,3,3,3},{11,4,2,3},{11,5,1,3},{11,6,0,3},{11,7,1,3},{11,8,2,3},
  {11,9,3,3},
  {4,3,3,3},{5,3,2,3},{6,3,1,3},{7,3,0,3},{8,3,1,3},{9,3,2,3},
  {10,3,3,3},
  {4,9,3,3},{5,9,2,3},{6,9,1,3},{7,9,0,3},{8,9,1,3},{9,9,2,3},
  {10,9,3,3},
  /* Level 4 */
  {4,4,2,4},{4,5,1,4},{4,6,0,4},{4,7,1,4},{4,8,2,4},
  {10,4,2,4},{10,5,1,4},{10,6,0,4},{10,7,1,4},{10,8,2,4},
  {5,4,2,4},{6,4,1,4},{7,4,0,4},{8,4,1,4},{9,4,2,4},
  {5,8,2,4},{6,8,1,4},{7,8,0,4},{8,8,1,4},{9,8,2,4},
  /* Level 5 */
  {5,5,1,5},{5,6,0,5},{5,7,1,5},
  {9,5,1,5},{9,6,0,5},{9,7,1,5},
  {6,5,1,5},{7,5,0,5},{8,5,1,5},
  {6,7,1,5},{7,7,0,5},{8,7,1,5},
  /* Terminator */
  {-1,-1,-1,-1}
};

static shri_xoff_data quad_xoff[] = { 
  0,7,13,18,22,25,-1 
};

/* Main diagonal shrink data */ /* added by stn*/

static shri_data diag_shri_data[] = {

  /* Level 0 */

  {0,0,6,0},{0,1,5,0},{0,2,4,0},{0,3,3,0},{0,4,2,0},{0,5,1,0},
  {0,6,0,0},{0,7,1,0},{0,8,2,0},{0,9,3,0},{0,10,4,0},{0,11,5,0},
  {0,12,5,0},
  {14,0,6,0},{14,1,5,0},{14,2,4,0},{14,3,3,0},{14,4,2,0},{14,5,1,0},
  {14,6,0,0},{14,7,1,0},{14,8,2,0},{14,9,3,0},{14,10,4,0},{14,11,5,0},
  {14,12,5,0},

  /* Level 1 */

  {1,0,6,1},{1,1,5,1},{1,2,4,1},{1,3,3,1},{1,4,2,1},{1,5,1,1},
  {1,6,0,1},{1,7,1,1},{1,8,2,1},{1,9,3,1},{1,10,4,1},{1,11,5,1},
  {1,12,5,1},
  {13,0,6,1},{13,1,5,1},{13,2,4,1},{13,3,3,1},{13,4,2,1},{13,5,1,1},
  {13,6,0,1},{13,7,1,1},{13,8,2,1},{13,9,3,1},{13,10,4,1},{13,11,5,1},
  {13,12,5,1},

  /* Level 2 */

  {2,0,0,2},

  /* Level 3 */

  {2,1,0,3},{3,0,0,3},

  /* Level 4 */

  {2,2,0,4},{3,1,0,4},{4,0,0,4},

  /* Level 5 */

  {2,3,1,5},{3,2,0,5},{4,1,1,5},{5,0,1,5},

  /* Level 6 */

  {2,4,1,6},{3,3,0,6},{4,2,0,6},{5,1,1,6},{6,0,1,6},

  /* Level 7 */

  {2,5,2,7},{3,4,1,7},{4,3,0,7},{5,2,1,7},{6,1,2,7},{7,0,2,7},

  /* Level 8 */

  {2,6,2,8},{3,5,1,8},{4,4,0,8},{5,3,0,8},{6,2,1,8},
  {7,1,2,8},{8,0,2,8},

  /* Level 9 */

  {2,7,3,9},{3,6,2,9},{4,5,1,9},{5,4,0,9},{6,3,1,9},
  {7,2,2,9},{8,1,3,9},{9,0,3,9},

  /* Level 10 */

  {2,8,3,10},{3,7,2,10},{4,6,1,10},{5,5,0,10},
  {6,4,0,10},{7,3,1,10},{8,2,2,10},{9,1,3,10},{10,0,3,10},

  /* Level 11 */

  {2,9,4,11},{3,8,3,11},{4,7,2,11},{5,6,1,11},
  {6,5,0,11},{7,4,1,11},{8,3,2,11},{9,2,3,11},{10,1,4,11},
  {11,0,4,11},

  /* Level 12 */

  {2,10,4,12},{3,9,3,12},{4,8,2,12},{5,7,1,12},
  {6,6,0,12},{7,5,0,12},{8,4,1,12},{9,3,2,12},{10,2,3,12},
  {11,1,4,12},{12,0,4,12},

  /* Level 13 */

  {2,11,5,13},{3,10,4,13},{4,9,3,13},{5,8,2,13},
  {6,7,1,13},{7,6,0,13},{8,5,1,13},{9,4,2,13},{10,3,3,13},
  {11,2,4,13},{12,1,5,13},

  /* Level 14 */

  {2,12,4,14},{3,11,4,14},{4,10,3,14},{5,9,2,14},{6,8,1,14},
  {7,7,0,14},{8,6,0,14},{9,5,1,14},{10,4,2,14},{11,3,3,14},
  {12,2,4,14},

  /* Level 15 */

  {3,12,4,15},{4,11,4,15},{5,10,3,15},{6,9,2,15},{7,8,1,15},
  {8,7,0,15},{9,6,1,15},{10,5,2,15},{11,4,3,15},{12,3,4,15},

  /* Level 16 */

  {4,12,3,16},{5,11,3,16},{6,10,2,16},{7,9,1,16},{8,8,0,16},
  {9,7,0,16},{10,6,1,16},{11,5,2,16},{12,4,3,16},

  /* Level 17 */

  {5,12,3,17},{6,11,3,17},{7,10,2,17},{8,9,1,17},{9,8,0,17},
  {10,7,1,17},{11,6,2,17},{12,5,3,17},

  /* Level 18 */

  {6,12,2,18},{7,11,2,18},{8,10,1,18},{9,9,0,18},{10,8,0,18},
  {11,7,1,18},{12,6,2,18},

  /* Level 19 */

  {7,12,2,19},{8,11,2,19},{9,10,1,19},{10,9,0,19},{11,8,1,19},
  {12,7,2,19},

  /* Level 20 */

  {8,12,1,20},{9,11,1,20},{10,10,0,20},{11,9,0,20},{12,8,1,20},

  /* Level 21 */

  {9,12,1,21},{10,11,1,21},{11,10,0,21},{12,9,1,21},

  /* Level 22 */

  {10,12,0,22},{11,11,0,22},{12,10,0,22},

  /* Level 23 */

  {11,12,0,23},{12,11,0,23},

  /* Level 24 */

  {12,12,0,24},

  /* Terminator */
  {-1,-1,-1,-1}

};

static shri_xoff_data diag_xoff[] =
  { 0,7,14,15,16,17,19,21,24,27,31,35,40,45,51,56,61,65,69,
    72,75,77,79,80,81,82,-1 };


/* EPFL */


/* Enserb stuff starts here */
static shri_data circle_data[] = {
  /* level 0 */
  
  {5,1,0,0},{6,1,0,0},{7,1,0,0},{8,1,0,0},{9,1,0,0},{4,2,0,0},{10,2,0,0},
  {3,3,0,0},{11,3,0,0},{2,4,0,0},{12,4,0,0},{2,5,0,0},{12,5,0,0},{2,6,0,0},
  {12,6,0,0},{2,7,0,0},{12,7,0,0},{12,8,0,0},{2,8,0,0},{3,9,0,0},{11,9,0,0},
  {4,10,0,0},{10,10,0,0},{5,11,0,0},{6,11,0,0},{7,11,0,0},{8,11,0,0},{9,11,0,0},
    
  /* Level 1 */

  {5,2,0,1},{6,2,0,1},{7,2,0,1},{8,2,0,1},{9,2,0,1},{4,3,0,1},{5,3,0,1},
  {9,3,0,1},{10,3,0,1},{3,4,0,1},{4,4,0,1},{10,4,0,1},{11,4,0,1},{3,5,0,1},
  {3,6,0,1},{3,7,0,1},{3,8,0,1},{11,5,0,1},{11,6,0,1},{11,7,0,1},{11,8,0,1},
  {5,10,0,1},{6,10,0,1},{7,10,0,1},{8,10,0,1},{9,10,0,1},{4,9,0,1},{5,9,0,1},
  {9,9,0,1},{10,9,0,1},{4,8,0,1},{10,8,0,1},
  
  /* Level 2 */

  {6,3,0,2},{7,3,0,2},{8,3,0,2},{5,4,0,2},{9,4,0,2},{4,5,0,2},{4,6,0,2},
  {4,7,0,2},{10,5,0,2},{10,6,0,2},{10,7,0,2},{5,8,0,2},{9,8,0,2},{6,9,0,2},
  {7,9,0,2},{8,9,0,2},
  
  /* Level 3 */
 
  {6,4,0,3},{7,4,0,3},{8,4,0,3},{5,5,0,3},{5,6,0,3},{5,7,0,3},{9,5,0,3},
  {9,6,0,3},{9,7,0,3},{6,8,0,3},{7,8,0,3},{8,8,0,3},
  
   /* Level 4 */

  {6,5,0,4},{7,5,0,4},{8,5,0,4},{6,6,0,4},{8,6,0,4},{6,7,0,4},{7,7,0,4},
  {8,7,0,4},
  
  /* Terminator */
  {-1,-1,-1,-1}
 
};

static shri_xoff_data circle_xoff[] =
  { 0,7,13,18,22,-1 };

static shri_data horiz_shri_data[] = {
/* Level 0 */

  {0,0,0,0},{0,1,0,0},{0,2,0,0},{0,3,0,0},{0,4,0,0},{0,5,0,0},
  {0,6,0,0},{0,7,0,0},{0,8,0,0},{0,9,0,0},{0,10,0,0},{0,11,0,0},
  {0,12,0,0},
  {14,0,0,0},{14,1,0,0},{14,2,0,0},{14,3,0,0},{14,4,0,0},{14,5,0,0},
  {14,6,0,0},{14,7,0,0},{14,8,0,0},{14,9,0,0},{14,10,0,0},{14,11,0,0},
  {14,12,0,0},
  
  /* Level 1 */

  {1,0,0,1},{1,1,0,1},{1,2,0,1},{1,3,0,1},{1,4,0,1},{1,5,0,1},{1,6,0,1},
  {1,7,0,1},{1,8,0,1},{1,9,0,1},{1,10,0,1},{1,11,0,1},{1,12,0,1},
  {13,0,0,1},{13,1,0,1},{13,2,0,1},{13,3,0,1},{13,4,0,1},{13,5,0,1},{13,6,0,1},
  {13,7,0,1},{13,8,0,1},{13,9,0,1},{13,10,0,1},{13,11,0,1},{13,12,0,1},
  
  /* Level 2 */

  {2,0,0,2},{2,1,0,2},{2,2,0,2},{2,3,0,2},{2,4,0,2},{2,5,0,2},{2,6,0,2},
  {2,7,0,2},{2,8,0,2},{2,9,0,2},{2,10,0,2},{2,11,0,2},{2,12,0,2},
  {12,0,0,2},{12,1,0,2},{12,2,0,2},{12,3,0,2},{12,4,0,2},{12,5,0,2},{12,6,0,2},
  {12,7,0,2},{12,8,0,2},{12,9,0,2},{12,10,0,2},{12,11,0,2},{12,12,0,2},
  
  /* Level 3 */
 
  {3,0,0,3},{3,1,0,3},{3,2,0,3},{3,3,0,3},{3,4,0,3},{3,5,0,3},{3,6,0,3},
  {3,7,0,3},{3,8,0,3},{3,9,0,3},{3,10,0,3},{3,11,0,3},{3,12,0,3},
  {11,0,0,3},{11,1,0,3},{11,2,0,3},{11,3,0,3},{11,4,0,3},{11,5,0,3},{11,6,0,3},
  {11,7,0,3},{11,8,0,3},{11,9,0,3},{11,10,0,3},{11,11,0,3},{11,13,0,3},
  
   /* Level 4 */

  {4,0,0,4},{4,1,0,4},{4,2,0,4},{4,3,0,4},{4,4,0,4},{4,5,0,4},{4,6,0,4},
  {4,7,0,4},{4,8,0,4},{4,9,0,4},{4,10,0,4},{4,11,0,4},{4,12,0,4},
  {10,0,0,4},{10,1,0,4},{10,2,0,4},{10,3,0,4},{10,4,0,4},{10,5,0,4},{10,6,0,4},
  {10,7,0,4},{10,8,0,4},{10,9,0,4},{10,10,0,4},{10,11,0,4},{10,14,0,4},
    
  /* Level 5 */

  {5,0,0,5},{5,1,0,5},{5,2,0,5},{5,3,0,5},{5,4,0,5},{5,5,0,5},{5,6,0,5},
  {5,7,0,5},{5,8,0,5},{5,9,0,5},{5,10,0,5},{5,11,0,5},{5,12,0,5},
  {9,0,0,5},{9,1,0,5},{9,2,0,5},{9,3,0,5},{9,4,0,5},{9,5,0,5},{9,6,0,5},
  {9,7,0,5},{9,8,0,5},{9,9,0,5},{9,10,0,5},{9,11,0,5},{9,14,0,5},
  
  /* Level 6 */

  {6,0,0,6},{6,1,0,6},{6,2,0,6},{6,3,0,6},{6,4,0,6},{6,5,0,6},{6,6,0,6},
  {6,7,0,6},{6,8,0,6},{6,9,0,6},{6,10,0,6},{6,11,0,6},{6,12,0,6},
  {8,0,0,6},{8,1,0,6},{8,2,0,6},{8,3,0,6},{8,4,0,6},{8,5,0,6},{8,6,0,6},
  {8,7,0,6},{8,8,0,6},{8,9,0,6},{8,10,0,6},{8,11,0,6},{8,14,0,6},
  
  /* Terminator */
  {-1,-1,-1,-1}
 

};

static shri_xoff_data horiz_xoff[] =
  { 0,7,13,18,22,25,29,-1 };

/* 4 blocs move shrink */

static shri_data move_data[] = {

/* level 0 */
{7,11,0,0},{7,1,0,0},{7,10,0,0},{7,2,0,0},{13,6,0,0},{1,6,0,0},{12,6,0,0},{2,6,0,0},{11,6,0,0},{3,6,0,0},
/* level 1 */
{7,10,0,1},{7,2,0,1},{7,9,0,1},{7,3,0,1},{12,6,0,1},{2,6,0,1},{11,6,0,1},{3,6,0,1},{10,6,0,1},{4,6,0,1},
/* level 2 */
{7,9,0,2},{7,3,0,2},{7,8,0,2},{7,4,0,2},{11,6,0,2},{3,6,0,2},{10,6,0,2},{4,6,0,2},{9,6,0,2},{5,6,0,2},
/* level 3 */
{7,8,0,3},{7,4,0,3},{7,7,0,3},{7,5,0,3},{10,6,0,3},{4,6,0,3},{9,6,0,3},{5,6,0,3},{8,6,0,3},{6,6,0,3},
/* level 4 */
{7,9,0,4},{7,3,0,4},{7,8,0,4},{7,4,0,4},{11,6,0,4},{3,6,0,4},{10,6,0,4},{4,6,0,4},{9,6,0,4},{5,6,0,4},
/* level 5 */
{7,10,0,5},{7,2,0,5},{7,9,0,5},{7,3,0,5},{12,6,0,5},{2,6,0,5},{11,6,0,5},{3,6,0,5},{10,6,0,5},{4,6,0,5},
/* level 6 */
{7,11,0,6},{7,1,0,6},{7,10,0,6},{7,2,0,6},{13,6,0,6},{1,6,0,6},{12,6,0,6},{2,6,0,6},{11,6,0,6},{3,6,0,6},
/* level 7 */
{7,10,0,7},{7,2,0,7},{7,9,0,7},{7,3,0,7},{12,6,0,7},{2,6,0,7},{11,6,0,7},{3,6,0,7},{10,6,0,7},{4,6,0,7},
/* level 8 */
{7,9,0,8},{7,3,0,8},{7,8,0,8},{7,4,0,8},{11,6,0,8},{3,6,0,8},{10,6,0,8},{4,6,0,8},{9,6,0,8},{5,6,0,8},
/* level 9 */
{7,8,0,9},{7,4,0,9},{7,7,0,9},{7,5,0,9},{10,6,0,9},{4,6,0,9},{9,6,0,9},{5,6,0,9},{8,6,0,9},{6,6,0,9},
/* level 10 */
{7,9,0,10},{7,3,0,10},{7,8,0,10},{7,4,0,10},{11,6,0,10},{3,6,0,10},{10,6,0,10},{4,6,0,10},{9,6,0,10},{5,6,0,10},
/* level 11 */
{7,10,0,11},{7,2,0,11},{7,9,0,11},{7,3,0,11},{12,6,0,11},{2,6,0,11},{11,6,0,11},{3,6,0,11},{10,6,0,11},{4,6,0,11},
/* level 12 */
{7,11,0,12},{7,1,0,12},{7,10,0,12},{7,2,0,12},{13,6,0,12},{1,6,0,12},{12,6,0,12},{2,6,0,12},{11,6,0,12},{3,6,0,12},
/* level 13 */
{7,10,0,13},{7,2,0,13},{7,9,0,13},{7,3,0,13},{12,6,0,13},{2,6,0,13},{11,6,0,13},{3,6,0,13},{10,6,0,13},{4,6,0,13},
/* level 14 */
{7,9,0,14},{7,3,0,14},{7,8,0,14},{7,4,0,14},{11,6,0,14},{3,6,0,14},{10,6,0,14},{4,6,0,14},{9,6,0,14},{5,6,0,14},
/* level 15 */
{7,8,0,15},{7,4,0,15},{7,7,0,15},{7,5,0,15},{10,6,0,15},{4,6,0,15},{9,6,0,15},{5,6,0,15},{8,6,0,15},{6,6,0,15},
/* level 16 */
{7,9,0,16},{7,3,0,16},{7,8,0,16},{7,4,0,16},{11,6,0,16},{3,6,0,16},{10,6,0,16},{4,6,0,16},{9,6,0,16},{5,6,0,16},
/* level 17 */
{7,10,0,17},{7,2,0,17},{7,9,0,17},{7,3,0,17},{12,6,0,17},{2,6,0,17},{11,6,0,17},{3,6,0,17},{10,6,0,17},{4,6,0,17},
/* level 18 */
{7,11,0,18},{7,1,0,18},{7,10,0,18},{7,2,0,18},{13,6,0,18},{1,6,0,18},{12,6,0,18},{2,6,0,18},{11,6,0,18},{3,6,0,18},
/* level 19 */
{7,10,0,19},{7,2,0,19},{7,9,0,19},{7,3,0,19},{12,6,0,19},{2,6,0,19},{11,6,0,19},{3,6,0,19},{10,6,0,19},{4,6,0,19},
/* level 20 */
{7,9,0,20},{7,3,0,20},{7,8,0,20},{7,4,0,20},{11,6,0,20},{3,6,0,20},{10,6,0,20},{4,6,0,20},{9,6,0,20},{5,6,0,20},
/* level 21 */
{7,8,0,21},{7,4,0,21},{7,7,0,21},{7,5,0,21},{10,6,0,21},{4,6,0,21},{9,6,0,21},{5,6,0,21},{8,6,0,21},{6,6,0,21},
/* level 22 */
{7,9,0,22},{7,3,0,22},{7,8,0,22},{7,4,0,22},{11,6,0,22},{3,6,0,22},{10,6,0,22},{4,6,0,22},{9,6,0,22},{5,6,0,22},
/* level 23 */
{7,10,0,23},{7,2,0,23},{7,9,0,23},{7,3,0,23},{12,6,0,23},{2,6,0,23},{11,6,0,23},{3,6,0,23},{10,6,0,23},{4,6,0,23},
/* level 24 */
{7,11,0,24},{7,1,0,24},{7,10,0,24},{7,2,0,24},{13,6,0,24},{1,6,0,24},{12,6,0,24},{2,6,0,24},{11,6,0,24},{3,6,0,24},
/* level 25 */
{7,10,0,25},{7,2,0,25},{7,9,0,25},{7,3,0,25},{12,6,0,25},{2,6,0,25},{11,6,0,25},{3,6,0,25},{10,6,0,25},{4,6,0,25},
/* level 26 */
{7,9,0,26},{7,3,0,26},{7,8,0,26},{7,4,0,26},{11,6,0,26},{3,6,0,26},{10,6,0,26},{4,6,0,26},{9,6,0,26},{5,6,0,26},
/* level 27 */
{7,8,0,27},{7,4,0,27},{7,7,0,27},{7,5,0,27},{10,6,0,27},{4,6,0,27},{9,6,0,27},{5,6,0,27},{8,6,0,27},{6,6,0,27},
/* level 28 */
{7,9,0,28},{7,3,0,28},{7,8,0,28},{7,4,0,28},{11,6,0,28},{3,6,0,28},{10,6,0,28},{4,6,0,28},{9,6,0,28},{5,6,0,28},
/* level 29 */
{7,10,0,29},{7,2,0,29},{7,9,0,29},{7,3,0,29},{12,6,0,29},{2,6,0,29},{11,6,0,29},{3,6,0,29},{10,6,0,29},{4,6,0,29},
/* level 30 */
{7,11,0,30},{7,1,0,30},{7,10,0,30},{7,2,0,30},{13,6,0,30},{1,6,0,30},{12,6,0,30},{2,6,0,30},{11,6,0,30},{3,6,0,30},
/* level 31 */
{7,10,0,31},{7,2,0,31},{7,9,0,31},{7,3,0,31},{12,6,0,31},{2,6,0,31},{11,6,0,31},{3,6,0,31},{10,6,0,31},{4,6,0,31},
/* level 32 */
{7,9,0,32},{7,3,0,32},{7,8,0,32},{7,4,0,32},{11,6,0,32},{3,6,0,32},{10,6,0,32},{4,6,0,32},{9,6,0,32},{5,6,0,32},
/* level 33 */
{7,8,0,33},{7,4,0,33},{7,7,0,33},{7,5,0,33},{10,6,0,33},{4,6,0,33},{9,6,0,33},{5,6,0,33},{8,6,0,33},{6,6,0,33},
/* level 34 */
{7,9,0,34},{7,3,0,34},{7,8,0,34},{7,4,0,34},{11,6,0,34},{3,6,0,34},{10,6,0,34},{4,6,0,34},{9,6,0,34},{5,6,0,34},
/* level 35 */
{7,10,0,35},{7,2,0,35},{7,9,0,35},{7,3,0,35},{12,6,0,35},{2,6,0,35},{11,6,0,35},{3,6,0,35},{10,6,0,35},{4,6,0,35},
/* level 36 */
{7,11,0,36},{7,1,0,36},{7,10,0,36},{7,2,0,36},{13,6,0,36},{1,6,0,36},{12,6,0,36},{2,6,0,36},{11,6,0,36},{3,6,0,36},
/* level 37 */
{7,10,0,37},{7,2,0,37},{7,9,0,37},{7,3,0,37},{12,6,0,37},{2,6,0,37},{11,6,0,37},{3,6,0,37},{10,6,0,37},{4,6,0,37},
/* level 38 */
{7,9,0,38},{7,3,0,38},{7,8,0,38},{7,4,0,38},{11,6,0,38},{3,6,0,38},{10,6,0,38},{4,6,0,38},{9,6,0,38},{5,6,0,38},
/* level 39 */
{7,8,0,39},{7,4,0,39},{7,7,0,39},{7,5,0,39},{10,6,0,39},{4,6,0,39},{9,6,0,39},{5,6,0,39},{8,6,0,39},{6,6,0,39},
/* level 40 */
{7,9,0,40},{7,3,0,40},{7,8,0,40},{7,4,0,40},{11,6,0,40},{3,6,0,40},{10,6,0,40},{4,6,0,40},{9,6,0,40},{5,6,0,40},
/* level 41 */
{7,10,0,41},{7,2,0,41},{7,9,0,41},{7,3,0,41},{12,6,0,41},{2,6,0,41},{11,6,0,41},{3,6,0,41},{10,6,0,41},{4,6,0,41},
/* level 42 */
{7,11,0,42},{7,1,0,42},{7,10,0,42},{7,2,0,42},{13,6,0,42},{1,6,0,42},{12,6,0,42},{2,6,0,42},{11,6,0,42},{3,6,0,42},
/* level 43 */
{7,10,0,43},{7,2,0,43},{7,9,0,43},{7,3,0,43},{12,6,0,43},{2,6,0,43},{11,6,0,43},{3,6,0,43},{10,6,0,43},{4,6,0,43},
/* level 44 */
{7,9,0,44},{7,3,0,44},{7,8,0,44},{7,4,0,44},{11,6,0,44},{3,6,0,44},{10,6,0,44},{4,6,0,44},{9,6,0,44},{5,6,0,44},
/* level 45 */
{7,8,0,45},{7,4,0,45},{7,7,0,45},{7,5,0,45},{10,6,0,45},{4,6,0,45},{9,6,0,45},{5,6,0,45},{8,6,0,45},{6,6,0,45},
/* level 46 */
{7,9,0,46},{7,3,0,46},{7,8,0,46},{7,4,0,46},{11,6,0,46},{3,6,0,46},{10,6,0,46},{4,6,0,46},{9,6,0,46},{5,6,0,46},
/* level 47 */
{7,10,0,47},{7,2,0,47},{7,9,0,47},{7,3,0,47},{12,6,0,47},{2,6,0,47},{11,6,0,47},{3,6,0,47},{10,6,0,47},{4,6,0,47},
/* level 48 */
{7,11,0,48},{7,1,0,48},{7,10,0,48},{7,2,0,48},{13,6,0,48},{1,6,0,48},{12,6,0,48},{2,6,0,48},{11,6,0,48},{3,6,0,48},
/* level 49 */
{7,10,0,49},{7,2,0,49},{7,9,0,49},{7,3,0,49},{12,6,0,49},{2,6,0,49},{11,6,0,49},{3,6,0,49},{10,6,0,49},{4,6,0,49},
/* level 50 */
{7,9,0,50},{7,3,0,50},{7,8,0,50},{7,4,0,50},{11,6,0,50},{3,6,0,50},{10,6,0,50},{4,6,0,50},{9,6,0,50},{5,6,0,50},
/* level 51 */
{7,8,0,51},{7,4,0,51},{7,7,0,51},{7,5,0,51},{10,6,0,51},{4,6,0,51},{9,6,0,51},{5,6,0,51},{8,6,0,51},{6,6,0,51},
/* level 52 */
{7,9,0,52},{7,3,0,52},{7,8,0,52},{7,4,0,52},{11,6,0,52},{3,6,0,52},{10,6,0,52},{4,6,0,52},{9,6,0,52},{5,6,0,52},
/* level 53 */
{7,10,0,53},{7,2,0,53},{7,9,0,53},{7,3,0,53},{12,6,0,53},{2,6,0,53},{11,6,0,53},{3,6,0,53},{10,6,0,53},{4,6,0,53},
/* level 54 */
{7,11,0,54},{7,1,0,54},{7,10,0,54},{7,2,0,54},{13,6,0,54},{1,6,0,54},{12,6,0,54},{2,6,0,54},{11,6,0,54},{3,6,0,54},
/* level 55 */
{7,10,0,55},{7,2,0,55},{7,9,0,55},{7,3,0,55},{12,6,0,55},{2,6,0,55},{11,6,0,55},{3,6,0,55},{10,6,0,55},{4,6,0,55},
/* level 56 */
{7,9,0,56},{7,3,0,56},{7,8,0,56},{7,4,0,56},{11,6,0,56},{3,6,0,56},{10,6,0,56},{4,6,0,56},{9,6,0,56},{5,6,0,56},
/* level 57 */
{7,8,0,57},{7,4,0,57},{7,7,0,57},{7,5,0,57},{10,6,0,57},{4,6,0,57},{9,6,0,57},{5,6,0,57},{8,6,0,57},{6,6,0,57},
/* level 58 */
{7,9,0,58},{7,3,0,58},{7,8,0,58},{7,4,0,58},{11,6,0,58},{3,6,0,58},{10,6,0,58},{4,6,0,58},{9,6,0,58},{5,6,0,58},
/* level 59 */
{7,10,0,59},{7,2,0,59},{7,9,0,59},{7,3,0,59},{12,6,0,59},{2,6,0,59},{11,6,0,59},{3,6,0,59},{10,6,0,59},{4,6,0,59},
/* level 60 */
{7,11,0,60},{7,1,0,60},{7,10,0,60},{7,2,0,60},{13,6,0,60},{1,6,0,60},{12,6,0,60},{2,6,0,60},{11,6,0,60},{3,6,0,60},
/* level 61 */
{7,10,0,61},{7,2,0,61},{7,9,0,61},{7,3,0,61},{12,6,0,61},{2,6,0,61},{11,6,0,61},{3,6,0,61},{10,6,0,61},{4,6,0,61},
/* level 62 */
{7,9,0,62},{7,3,0,62},{7,8,0,62},{7,4,0,62},{11,6,0,62},{3,6,0,62},{10,6,0,62},{4,6,0,62},{9,6,0,62},{5,6,0,62},
/* level 63 */
{7,8,0,63},{7,4,0,63},{7,7,0,63},{7,5,0,63},{10,6,0,63},{4,6,0,63},{9,6,0,63},{5,6,0,63},{8,6,0,63},{6,6,0,63},
/* level 64 */
{7,9,0,64},{7,3,0,64},{7,8,0,64},{7,4,0,64},{11,6,0,64},{3,6,0,64},{10,6,0,64},{4,6,0,64},{9,6,0,64},{5,6,0,64},
/* level 65 */
{7,10,0,65},{7,2,0,65},{7,9,0,65},{7,3,0,65},{12,6,0,65},{2,6,0,65},{11,6,0,65},{3,6,0,65},{10,6,0,65},{4,6,0,65},
/* level 66 */
{7,11,0,66},{7,1,0,66},{7,10,0,66},{7,2,0,66},{13,6,0,66},{1,6,0,66},{12,6,0,66},{2,6,0,66},{11,6,0,66},{3,6,0,66},
/* level 67 */
{7,10,0,67},{7,2,0,67},{7,9,0,67},{7,3,0,67},{12,6,0,67},{2,6,0,67},{11,6,0,67},{3,6,0,67},{10,6,0,67},{4,6,0,67},
/* level 68 */
{7,9,0,68},{7,3,0,68},{7,8,0,68},{7,4,0,68},{11,6,0,68},{3,6,0,68},{10,6,0,68},{4,6,0,68},{9,6,0,68},{5,6,0,68},
/* level 69 */
{7,8,0,69},{7,4,0,69},{7,7,0,69},{7,5,0,69},{10,6,0,69},{4,6,0,69},{9,6,0,69},{5,6,0,69},{8,6,0,69},{6,6,0,69},
/* level 70 */
{7,9,0,70},{7,3,0,70},{7,8,0,70},{7,4,0,70},{11,6,0,70},{3,6,0,70},{10,6,0,70},{4,6,0,70},{9,6,0,70},{5,6,0,70},
/* level 71 */
{7,10,0,71},{7,2,0,71},{7,9,0,71},{7,3,0,71},{12,6,0,71},{2,6,0,71},{11,6,0,71},{3,6,0,71},{10,6,0,71},{4,6,0,71},
/* level 72 */
{7,11,0,72},{7,1,0,72},{7,10,0,72},{7,2,0,72},{13,6,0,72},{1,6,0,72},{12,6,0,72},{2,6,0,72},{11,6,0,72},{3,6,0,72},
/* level 73 */
{7,10,0,73},{7,2,0,73},{7,9,0,73},{7,3,0,73},{12,6,0,73},{2,6,0,73},{11,6,0,73},{3,6,0,73},{10,6,0,73},{4,6,0,73},
/* level 74 */
{7,9,0,74},{7,3,0,74},{7,8,0,74},{7,4,0,74},{11,6,0,74},{3,6,0,74},{10,6,0,74},{4,6,0,74},{9,6,0,74},{5,6,0,74},
/* level 75 */
{7,8,0,75},{7,4,0,75},{7,7,0,75},{7,5,0,75},{10,6,0,75},{4,6,0,75},{9,6,0,75},{5,6,0,75},{8,6,0,75},{6,6,0,75},
/* level 76 */
{7,9,0,76},{7,3,0,76},{7,8,0,76},{7,4,0,76},{11,6,0,76},{3,6,0,76},{10,6,0,76},{4,6,0,76},{9,6,0,76},{5,6,0,76},
/* level 77 */
{7,10,0,77},{7,2,0,77},{7,9,0,77},{7,3,0,77},{12,6,0,77},{2,6,0,77},{11,6,0,77},{3,6,0,77},{10,6,0,77},{4,6,0,77},
/* level 78 */
{7,11,0,78},{7,1,0,78},{7,10,0,78},{7,2,0,78},{13,6,0,78},{1,6,0,78},{12,6,0,78},{2,6,0,78},{11,6,0,78},{3,6,0,78},
/* level 79 */
{7,10,0,79},{7,2,0,79},{7,9,0,79},{7,3,0,79},{12,6,0,79},{2,6,0,79},{11,6,0,79},{3,6,0,79},{10,6,0,79},{4,6,0,79},
/* level 80 */
{7,9,0,80},{7,3,0,80},{7,8,0,80},{7,4,0,80},{11,6,0,80},{3,6,0,80},{10,6,0,80},{4,6,0,80},{9,6,0,80},{5,6,0,80},
/* level 81 */
{7,8,0,81},{7,4,0,81},{7,7,0,81},{7,5,0,81},{10,6,0,81},{4,6,0,81},{9,6,0,81},{5,6,0,81},{8,6,0,81},{6,6,0,81},
/* level 82 */
{7,9,0,82},{7,3,0,82},{7,8,0,82},{7,4,0,82},{11,6,0,82},{3,6,0,82},{10,6,0,82},{4,6,0,82},{9,6,0,82},{5,6,0,82},
/* level 83 */
{7,10,0,83},{7,2,0,83},{7,9,0,83},{7,3,0,83},{12,6,0,83},{2,6,0,83},{11,6,0,83},{3,6,0,83},{10,6,0,83},{4,6,0,83},
/* level 84 */
{7,11,0,84},{7,1,0,84},{7,10,0,84},{7,2,0,84},{13,6,0,84},{1,6,0,84},{12,6,0,84},{2,6,0,84},{11,6,0,84},{3,6,0,84},
/* level 85 */
{7,10,0,85},{7,2,0,85},{7,9,0,85},{7,3,0,85},{12,6,0,85},{2,6,0,85},{11,6,0,85},{3,6,0,85},{10,6,0,85},{4,6,0,85},
/* level 86 */
{7,9,0,86},{7,3,0,86},{7,8,0,86},{7,4,0,86},{11,6,0,86},{3,6,0,86},{10,6,0,86},{4,6,0,86},{9,6,0,86},{5,6,0,86},
/* level 87 */
{7,8,0,87},{7,4,0,87},{7,7,0,87},{7,5,0,87},{10,6,0,87},{4,6,0,87},{9,6,0,87},{5,6,0,87},{8,6,0,87},{6,6,0,87},
/* level 88 */
{7,9,0,88},{7,3,0,88},{7,8,0,88},{7,4,0,88},{11,6,0,88},{3,6,0,88},{10,6,0,88},{4,6,0,88},{9,6,0,88},{5,6,0,88},
/* level 89 */
{7,10,0,89},{7,2,0,89},{7,9,0,89},{7,3,0,89},{12,6,0,89},{2,6,0,89},{11,6,0,89},{3,6,0,89},{10,6,0,89},{4,6,0,89},
/* level 90 */
{7,11,0,90},{7,1,0,90},{7,10,0,90},{7,2,0,90},{13,6,0,90},{1,6,0,90},{12,6,0,90},{2,6,0,90},{11,6,0,90},{3,6,0,90},
/* level 91 */
{7,10,0,91},{7,2,0,91},{7,9,0,91},{7,3,0,91},{12,6,0,91},{2,6,0,91},{11,6,0,91},{3,6,0,91},{10,6,0,91},{4,6,0,91},
/* level 92 */
{7,9,0,92},{7,3,0,92},{7,8,0,92},{7,4,0,92},{11,6,0,92},{3,6,0,92},{10,6,0,92},{4,6,0,92},{9,6,0,92},{5,6,0,92},
/* level 93 */
{7,8,0,93},{7,4,0,93},{7,7,0,93},{7,5,0,93},{10,6,0,93},{4,6,0,93},{9,6,0,93},{5,6,0,93},{8,6,0,93},{6,6,0,93},
/* level 94 */
{7,9,0,94},{7,3,0,94},{7,8,0,94},{7,4,0,94},{11,6,0,94},{3,6,0,94},{10,6,0,94},{4,6,0,94},{9,6,0,94},{5,6,0,94},
/* level 95 */
{7,10,0,95},{7,2,0,95},{7,9,0,95},{7,3,0,95},{12,6,0,95},{2,6,0,95},{11,6,0,95},{3,6,0,95},{10,6,0,95},{4,6,0,95},
/* level 96 */
{7,11,0,96},{7,1,0,96},{7,10,0,96},{7,2,0,96},{13,6,0,96},{1,6,0,96},{12,6,0,96},{2,6,0,96},{11,6,0,96},{3,6,0,96},
/* level 97 */
{7,10,0,97},{7,2,0,97},{7,9,0,97},{7,3,0,97},{12,6,0,97},{2,6,0,97},{11,6,0,97},{3,6,0,97},{10,6,0,97},{4,6,0,97},
/* level 98 */
{7,9,0,98},{7,3,0,98},{7,8,0,98},{7,4,0,98},{11,6,0,98},{3,6,0,98},{10,6,0,98},{4,6,0,98},{9,6,0,98},{5,6,0,98},
/* level 99 */
{7,8,0,99},{7,4,0,99},{7,7,0,99},{7,5,0,99},{10,6,0,99},{4,6,0,99},{9,6,0,99},{5,6,0,99},{8,6,0,99},{6,6,0,99},
/* level 100 */
{7,9,0,100},{7,3,0,100},{7,8,0,100},{7,4,0,100},{11,6,0,100},{3,6,0,100},{10,6,0,100},{4,6,0,100},{9,6,0,100},{5,6,0,100},
/* level 101 */
{7,10,0,101},{7,2,0,101},{7,9,0,101},{7,3,0,101},{12,6,0,101},{2,6,0,101},{11,6,0,101},{3,6,0,101},{10,6,0,101},{4,6,0,101},
/* level 102 */
{7,11,0,102},{7,1,0,102},{7,10,0,102},{7,2,0,102},{13,6,0,102},{1,6,0,102},{12,6,0,102},{2,6,0,102},{11,6,0,102},{3,6,0,102},
/* level 103 */
{7,10,0,103},{7,2,0,103},{7,9,0,103},{7,3,0,103},{12,6,0,103},{2,6,0,103},{11,6,0,103},{3,6,0,103},{10,6,0,103},{4,6,0,103},
/* level 104 */
{7,9,0,104},{7,3,0,104},{7,8,0,104},{7,4,0,104},{11,6,0,104},{3,6,0,104},{10,6,0,104},{4,6,0,104},{9,6,0,104},{5,6,0,104},
/* level 105 */
{7,8,0,105},{7,4,0,105},{7,7,0,105},{7,5,0,105},{10,6,0,105},{4,6,0,105},{9,6,0,105},{5,6,0,105},{8,6,0,105},{6,6,0,105},
/* level 106 */
{7,9,0,106},{7,3,0,106},{7,8,0,106},{7,4,0,106},{11,6,0,106},{3,6,0,106},{10,6,0,106},{4,6,0,106},{9,6,0,106},{5,6,0,106},
/* level 107 */
{7,10,0,107},{7,2,0,107},{7,9,0,107},{7,3,0,107},{12,6,0,107},{2,6,0,107},{11,6,0,107},{3,6,0,107},{10,6,0,107},{4,6,0,107},
/* level 108 */
{7,11,0,108},{7,1,0,108},{7,10,0,108},{7,2,0,108},{13,6,0,108},{1,6,0,108},{12,6,0,108},{2,6,0,108},{11,6,0,108},{3,6,0,108},
/* level 109 */
{7,10,0,109},{7,2,0,109},{7,9,0,109},{7,3,0,109},{12,6,0,109},{2,6,0,109},{11,6,0,109},{3,6,0,109},{10,6,0,109},{4,6,0,109},
/* level 110 */
{7,9,0,110},{7,3,0,110},{7,8,0,110},{7,4,0,110},{11,6,0,110},{3,6,0,110},{10,6,0,110},{4,6,0,110},{9,6,0,110},{5,6,0,110},
/* level 111 */
{7,8,0,111},{7,4,0,111},{7,7,0,111},{7,5,0,111},{10,6,0,111},{4,6,0,111},{9,6,0,111},{5,6,0,111},{8,6,0,111},{6,6,0,111},
/* level 112 */
{7,9,0,112},{7,3,0,112},{7,8,0,112},{7,4,0,112},{11,6,0,112},{3,6,0,112},{10,6,0,112},{4,6,0,112},{9,6,0,112},{5,6,0,112},
/* level 113 */
{7,10,0,113},{7,2,0,113},{7,9,0,113},{7,3,0,113},{12,6,0,113},{2,6,0,113},{11,6,0,113},{3,6,0,113},{10,6,0,113},{4,6,0,113},
/* level 114 */
{7,11,0,114},{7,1,0,114},{7,10,0,114},{7,2,0,114},{13,6,0,114},{1,6,0,114},{12,6,0,114},{2,6,0,114},{11,6,0,114},{3,6,0,114},
/* level 115 */
{7,10,0,115},{7,2,0,115},{7,9,0,115},{7,3,0,115},{12,6,0,115},{2,6,0,115},{11,6,0,115},{3,6,0,115},{10,6,0,115},{4,6,0,115},
/* level 116 */
{7,9,0,116},{7,3,0,116},{7,8,0,116},{7,4,0,116},{11,6,0,116},{3,6,0,116},{10,6,0,116},{4,6,0,116},{9,6,0,116},{5,6,0,116},
/* level 117 */
{7,8,0,117},{7,4,0,117},{7,7,0,117},{7,5,0,117},{10,6,0,117},{4,6,0,117},{9,6,0,117},{5,6,0,117},{8,6,0,117},{6,6,0,117},
/* level 118 */
{7,9,0,118},{7,3,0,118},{7,8,0,118},{7,4,0,118},{11,6,0,118},{3,6,0,118},{10,6,0,118},{4,6,0,118},{9,6,0,118},{5,6,0,118},
/* level 119 */
{7,10,0,119},{7,2,0,119},{7,9,0,119},{7,3,0,119},{12,6,0,119},{2,6,0,119},{11,6,0,119},{3,6,0,119},{10,6,0,119},{4,6,0,119},

{-1,-1,-1,-1}
};

static shri_xoff_data move_xoff[] =
{1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120};
/* Enserb stuff stops here */

/* EPFL */

/* 
 * Style data 
 */

/* style_rise_2: Rises a block for 2 time frames */
static shri_style2 style_rise_2_xx[] = {
  {  0,  0, BTBlockRise},
  {  2,  0, BTBlock}
};
static shri_style style_rise_2 = {2, style_rise_2_xx};

/* style_rise_2_plus: Rises a block for 2 time frames, deletes blocks on previous levels */
static shri_style2 style_rise_2_plus_xx[] = {
  {  0,  0, BTBlockRise},
  {  2,  0, BTBlock},
  {  2, -1, BTVoid}
};
static shri_style style_rise_2_plus = {3, style_rise_2_plus_xx};

/* style_compound: Gives an 8 time frame warning on previous level before placing blocks on the current one */
static shri_style2 style_compound_xx[] = {
  { -8, -1, BTBlockRise},
  {  0, -1, BTVoid},
  {  0,  0, BTBlock}
};
static shri_style style_compound = {3, style_compound_xx};

/* style_compound_solid: Similar to above but rises the new blocks */
static shri_style2 style_compound_solid_xx[] = {
  {-16, -1, BTBlockRise},
  {-12, -1, BTBlock},
  { -6,  0, BTBlockRise},
  {  0,  0, BTBlock}
};
static shri_style style_compound_solid = {4, style_compound_solid_xx};

/* style_compound_extra: Compound style with extras */
static shri_style2 style_compound_extra_xx[] = {
  {-16, -2, BTBlockRise},
  {-12, -2, BTVoid},
  {-12, -1, BTBlock},
  { -4, -1, BTBlockRise},
  {  0, -1, BTVoid},
  {  0,  0, BTBlock},
  {  4,  0, BTBlockRise},
  {  8,  0, BTExtra},
  {  8, -1, BTBlock}
};
static shri_style style_compound_extra = {9, style_compound_extra_xx};

/* 2 levels of compound */
static shri_style2 style_savage_compound_xx[] = {
  {-10, -2, BTBlockRise},
  { -6, -2, BTVoid},
  { -6, -1, BTBlock},
  { -4, -1, BTBlockRise},
  {  0, -1, BTVoid},
  {  0,  0, BTBlock}
};
static shri_style style_savage_compound = {6, style_savage_compound_xx};

/* EPFL */

/* new fcn by XBLAS@T ; inserted by EPFL - x-bresse */
static shri_style2 style_outward_compound_extra_xx[] = {
  {-16,  1, BTBlockRise},
  {-12,  1, BTBlock},
  {-12,  0, -1},        /* 'V' block */
  { -4,  1, BTBlockRise},
  {  0,  1, BTExtra},
  {  0,  0, BTBlock},
  {  4,  0, BTBlockRise},
  {  8,  0, BTExtra},
  {  8, -1, BTBlock}
};

static shri_style style_outward_compound_extra = {9,
style_outward_compound_extra_xx};

/* Added by Enserb : test de mouvement */

static shri_style2 style_move_xx[] = {
  { 0, 0, BTBlock},
  { 33,0,BTFree}
};

static shri_style style_move ={2, style_move_xx};
/* End of Added by Enserb */

/* EPFL */

#endif
/*
 * end of file shrinkdat.h
 */
