#ifndef _UTILS_H
#define _UTILS_H

#include <stdlib.h>

struct _Set {
  void ** element;
  int size, max_size;
};
typedef struct _Set * Set;

struct _Vector {
  int * element;
  int size, max_size;
};
typedef struct _Vector * Vector;

void *xmalloc( size_t size );
void *xrealloc ( void *p, size_t size);

int rnd( int range );

Set new_set( int max_size );
void delete_set( Set s );
void add_element_to_set( Set s, void * p );
void remove_element_from_set( Set s, void * p );
void remove_element_from_set_at( Set s, int i );
void empty_set( Set s );

Vector new_vector( int max_size );
void delete_vector( Vector v );
void add_element_to_vector( Vector v, int p );
int element_is_in_vector( Vector v, int p );
void empty_vector( Vector v );

#define clip( X, m, M ) (( X < m )? m : (( X > M )? M : X ))

#endif /* _UTILS_H */
