/******************************************************************
 
        MUSCLE SmartCard Development ( http://www.musclecard.com )
            Title  : xcardManagePIN.h
            Author : David Corcoran
            Date   : 10/05/01
	    License: Copyright (C) 2001 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This provides functionality for the xcard
	             personalization tool for the musclecard.
 
********************************************************************/ 

#ifndef xcardManagePIN_included
#define xcardManagePIN_included

#include "xcardManagePINData.h"
#include "xcardMain.h"

#ifdef MSC_TARGET_OSX
#include <PCSC/musclecard.h>
#else
#include <musclecard.h>
#endif


class xcardManagePIN : public xcardManagePINData
{
    Q_OBJECT

public:

    MSCLPTokenConnection pConnect;
    MSCULong32 pinNumber;
    xcardMain *mainWindow;

    xcardManagePIN(
		   MSCLPTokenConnection pConn,
		   MSCULong32 pinNum,
		   xcardMain *mainWin,
		   QWidget *parent = NULL,
		   const char *name = NULL );

    virtual ~xcardManagePIN();

    void XCFillPINBox(bool isChangePIN);

    protected slots:

    virtual void XCPinManageCancelClick();
    virtual void XCPinManageCheckClicked(bool);
    virtual void XCPinManageOKClicked();
};
#endif // xcardManagePIN_included
