/* -*-Mode: C;-*-
 * $Id: xdelta.h,v 1.10 2001/05/15 23:34:05 jmacd Exp $
 *
 * Copyright (C) 1997, 1998, 1999, 2000, Joshua P. MacDonald
 * <jmacd@CS.Berkeley.EDU> and The Regents of the University of
 * California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _XDELTA_H_
#define _XDELTA_H_

#ifdef __cplusplus
extern "C" {
#if 0
}
#endif
#endif

#include "xd_edsio.h"

typedef SerialXdeltaChecksum      XdeltaChecksum;
typedef SerialXdeltaControl       XdeltaControl;
typedef SerialXdeltaInstruction   XdeltaInstruction;

typedef struct _XdeltaGenerator   XdeltaGenerator;
typedef struct _XdeltaSource      XdeltaSource;

typedef FileHandle XdeltaStream;
typedef FileHandle XdeltaOutStream;

enum _XdeltaSourceType {
  XS_Primary   = 1,
  XS_Secondary = 2,
  XS_Patch     = 3
};

#define src_count src_types_len

typedef enum _XdeltaSourceType XdeltaSourceType;

/* Note: FileHandle is an opaque type, you must define it
k * to use this library.  See how its done in xdmain.c.
 */

/* copy segments are of length 1<<QUERY_SIZE, this must not be greater
 * than 6 due to a space assumption, and also limits the number of
 * sources allowed to (QUERY_SIZE_POW-1). */
#define QUERY_SIZE          4
#define QUERY_SIZE_POW      (1<<QUERY_SIZE)
#define QUERY_SIZE_MASK     (QUERY_SIZE_POW-1)

#define MAX_XDELTA_SOURCES  QUERY_SIZE_MASK

/* An xdelta consists of two pieces of information, the control and
 * data segments.  The control segment consists of instructions,
 * metadata, and some redundent information for validation.  The data
 * segment consists of literal data not found in any of the sources.
 *
 * The library operates on two types of streams, random access and
 * non-seekable.  Briefly, you initialize a XdeltaGenerator with one
 * or more XdeltaSources.  These XdeltaSources contain a random access
 * stream (a FROM file).
 *
 * The generator is initialized with an input stream and an output
 * stream, these streams are not seekable.
 *
 * The creation of a XdeltaSource requires a complete pass through the
 * file.  This pass pre-computes an index which is used during delta
 * computation.  This index may be saved and restored to avoid
 * computing it multiple times.
 */

XdeltaGenerator* xdp_generator_new      (void);

/* Create a new source.  Returns the source on success, NULL on
 * failure. */

XdeltaSource*    xdp_source_new           (XdeltaStream     *source_in,
					   XdeltaSourceType  src_type,
					   void             *src_data);

/* Add SRC to the generator.  The source will then be used for generating
 * deltas. */
gboolean         xdp_source_add           (XdeltaGenerator *gen,
					   XdeltaSource    *src);

/* Actually generate a delta against the accumulated sources in GEN.
 * Returns the delta's controller or NULL on failure. */
XdeltaControl*   xdp_generate_delta       (XdeltaGenerator *gen,
					   XdeltaStream    *in,
					   XdeltaOutStream *control_out,
					   XdeltaOutStream *data_out);

/* Reads a control object from a stream. */
XdeltaControl*   xdp_control_read         (XdeltaStream    *cont_in);

/* Writes a control object to a stream. */
gboolean         xdp_control_write        (XdeltaControl   *cont,
					   XdeltaOutStream *cont_out);

void*            xdp_source_data          (XdeltaGenerator   *gen,
					   guint              index);
guint32          xdp_source_copies        (XdeltaGenerator   *gen,
					   guint              index);
gboolean         xdp_has_data             (XdeltaGenerator   *gen);


/* Free the above structures */
void             xdp_source_free          (XdeltaSource    *src);
void             xdp_generator_free       (XdeltaGenerator *gen);
void             xdp_control_free         (XdeltaControl   *con);

#ifdef __cplusplus
}
#endif

#endif
