#include "storage.h"


class SPECIAL_FORMAT
{
public:

    SPECIAL_FORMAT ();

    virtual int         magic_len () = 0;
    virtual const char* magic_val () = 0;
};

class SPECIAL_AR
    : public SPECIAL_FORMAT
{
public:

    SPECIAL_AR ();

    virtual int         magic_len () { return 8; }
    virtual const char* magic_val () { return "!<arch>\n"; }
};

class SPECIAL_GZIP
    : public SPECIAL_FORMAT
{
public:

    SPECIAL_GZIP ();

    virtual int         magic_len () { return 2; }
    virtual const char* magic_val () { return "\037\0213"; }
};

int main (int argc, char **argv)
{
    // This is an un-written test routine for the eventual special
    // handling for Dpkg format AR/gzip files.
}




// Old code from Xdelta-0.23
#if 0

#define AR_Z_PREFIX 5

static MappedFile*
map_arfile (const gchar *filename)
{
  MappedFile *map;
  int fd = open (filename, O_RDONLY);
  int t_read = 0;
  char* n_seg = g_new (char, BUFSIZ);
  int n_seg_len = BUFSIZ;

  if (fd < 0)
    return NULL;

  if (! read_and_alloc (&n_seg, &n_seg_len, &t_read, strlen(ARMAG), fd, NULL))
    goto badar;

  for (;;)
    {
      int file_len;
      int done;
      int old_t_read = t_read;
      struct ar_hdr *hdr;
      unsigned char is_gzipped = FALSE;
      unsigned char zhdr[AR_Z_PREFIX];
      int zhdr_offset;

      if (! read_and_alloc (&n_seg, &n_seg_len, &t_read, AR_HDR_LEN, fd, &done))
	{
	  if (done == 0)
	    break;
	  goto badar;
	}

      hdr = (struct ar_hdr*)(n_seg + old_t_read);

      if (strncmp (hdr->ar_name, "#1/", 3) == 0)
	{
	  int name_len;

	  /* Use the extended format (man 5 ar on FreeBSD). */
	  if (! read_num (hdr->ar_name + 3, sizeof (hdr->ar_name) - 3, &name_len))
	    goto badar;

	  if (! read_and_alloc (&n_seg, &n_seg_len, &t_read, name_len, fd, NULL))
	    goto badar;
	}

      if (! read_num (hdr->ar_size, sizeof (hdr->ar_size), &file_len))
	goto badar;

      /* read file_len bytes */
      if (file_len > 2)
	{
	  /* look for gzip. */
	  unsigned char buf[2];

	  if (read (fd, buf, 2) != 2)
	    goto badar;

	  if (lseek (fd, - 2, SEEK_CUR) < 0)
	    goto badar;

	  if (buf[0] == GZIP_MAGIC1 && buf[1] == GZIP_MAGIC2)
	    is_gzipped = TRUE;
	}

      memset (zhdr, 0, AR_Z_PREFIX);
      zhdr[0] = is_gzipped;
      zhdr_offset = t_read;

      append_seg (&n_seg, &n_seg_len, &t_read, zhdr, AR_Z_PREFIX);

      if (is_gzipped)
	{
	  int old_t_read = t_read;
	  gint32 zsize;

	  if (! gzread_and_alloc_range (&n_seg, &n_seg_len, &t_read, file_len, fd))
	    goto badar;

	  zsize = t_read - old_t_read;

	  zsize = htonl (zsize);

	  memcpy (n_seg + zhdr_offset + 1, &zsize, sizeof (zsize));
	}
      else
	{
	  if (! read_and_alloc (&n_seg, &n_seg_len, &t_read, file_len, fd, NULL))
	    goto badar;
	}

      if (file_len % 2)
	{
	  char it;

	  if (read (fd, &it, 1) != 1)
	    goto badar;
	}
    }

  map = new_map (n_seg, t_read);

  return map;

badar:
  close (fd);

  return NULL;
}

static gint
recompress_arfile (datum file, const char* name)
{
  int fd = open (name, O_WRONLY | O_CREAT | O_TRUNC, 0666);
  int pos = 0;
  int rem = file.dsize;

  if (fd < 0)
    return FALSE;

  if (rem < strlen (ARMAG))
    return FALSE;

  if (write (fd, file.dptr, strlen (ARMAG)) != strlen (ARMAG))
    return FALSE;

  pos += strlen (ARMAG);
  rem -= strlen (ARMAG);

  for (;;)
    {
      int file_len;
      struct ar_hdr *hdr;
      gint32 zsize;
      unsigned char is_gzipped;
      int hdr_offset;

      if (rem == 0)
	break;

      if (rem < AR_HDR_LEN)
	return FALSE;

      hdr_offset = lseek (fd, 0, SEEK_CUR);

      if (write (fd, file.dptr + pos, AR_HDR_LEN) != AR_HDR_LEN)
	return FALSE;

      hdr = (struct ar_hdr*)(file.dptr + pos);

      pos += AR_HDR_LEN;
      rem -= AR_HDR_LEN;

      if (strncmp (hdr->ar_name, "#1/", 3) == 0)
	{
	  int name_len;

	  /* Use the extended format (man 5 ar on FreeBSD). */
	  if (! read_num (hdr->ar_name + 3, sizeof (hdr->ar_name) - 3, &name_len))
	    return FALSE;

	  if (rem < name_len)
	    return FALSE;

	  if (write (fd, file.dptr + pos, name_len) != name_len)
	    return FALSE;

	  pos += name_len;
	  rem -= name_len;
	}

      if (rem < AR_Z_PREFIX)
	return FALSE;

      is_gzipped = ((unsigned char*)file.dptr)[pos];

      pos += 1;
      rem -= 1;

      memcpy (&zsize, file.dptr + pos, sizeof(zsize));

      zsize = ntohl (zsize);

      pos += 4;
      rem -= 4;

      if (is_gzipped)
	{
	  int nfd = dup(fd);
	  gzFile *it = gzdopen (nfd, "wb6");
	  int before_off = lseek (fd, 0, SEEK_CUR);
	  int after_off;
	  int newsize;

	  if (!it)
	    return FALSE;

	  if (rem < zsize)
	    return FALSE;

	  if (gzwrite (it, file.dptr + pos, zsize) != zsize)
	    return FALSE;

	  if (gzclose (it) != Z_OK)
	    return FALSE;

	  after_off = lseek (fd, 0, SEEK_END);

	  if (after_off < 0)
	    return FALSE;

	  newsize = after_off - before_off;

	  /* fix the length */
	  if (lseek (fd, hdr_offset + 48, SEEK_SET) < 0)
	    return FALSE;

	  {
	    char buf[sizeof (hdr->ar_size)];

	    memset (buf, ' ', sizeof (hdr->ar_size));

	    sprintf (buf, "%d", newsize);

	    buf[strlen(buf)] = ' ';

	    if (write (fd, buf, sizeof (hdr->ar_size)) != sizeof (hdr->ar_size))
	      return FALSE;
	  }

	  if (lseek (fd, 0, SEEK_END) < 0)
	    return FALSE;

	  file_len = newsize;

	  pos += zsize;
	  rem -= zsize;
	}
      else
	{
	  if (! read_num (hdr->ar_size, sizeof (hdr->ar_size), &file_len))
	    return FALSE;

	  if (rem < file_len)
	    return FALSE;

	  if (write (fd, file.dptr + pos, file_len) != file_len)
	    return FALSE;

	  pos += file_len;
	  rem -= file_len;
	}

      if (file_len % 2)
	{
	  char it = '\n';

	  if (write (fd, &it, 1) != 1)
	    return FALSE;
	}
    }

  return (close (fd) >= 0);
}

gint
file_archive_type (const char* file, int* method)
{
  FILE* f = fopen (file, "r");
  unsigned char buf[8];
  int res = UNCOMPRESS_NONE;

  if (! f)
    {
      xd_error ("cannot read: %s: %s\n", file, g_strerror (errno));
      return FALSE;
    }

  if (fread (buf, 1, 8, f) != 8)
    goto no;

  if (buf[0] == GZIP_MAGIC1 && buf[1] == GZIP_MAGIC2)
    {
      res = UNCOMPRESS_GZIP;
    }
  else if (buf[0] == RPMLEAD_MAGIC0 &&
	   buf[1] == RPMLEAD_MAGIC1 &&
	   buf[2] == RPMLEAD_MAGIC2 &&
	   buf[3] == RPMLEAD_MAGIC3)
    {
      res = UNCOMPRESS_RPM30;
    }
  else if (strncmp (buf, ARMAG, strlen(ARMAG)) == 0)
    {
      res = UNCOMPRESS_AR;
    }

no:

  *method = res;

  fclose (f);

  return TRUE;
}

MappedFile*
unarchive_file (const char* name, int method)
{
  switch (method)
    {
    case UNCOMPRESS_NONE:
      return map_file (name);
    case UNCOMPRESS_GZIP:
      return map_gzfile (name);
    case UNCOMPRESS_RPM30:
      return map_rpm30file (name);
    case UNCOMPRESS_AR:
      return map_arfile (name);
    default:
      g_error ("xdelta: %s has an unrecognized external archive/compression method %d, please upgrade!",
	       name, method);
      break;
    }

  return NULL;
}

gint
archive_file (datum file, const char* name, int method)
{
  switch (method)
    {
    case UNCOMPRESS_NONE:
      {
	FILE* reconst_out;

	if (!(reconst_out = fopen (name, FOPEN_WRITE_ARG)))
	  return FALSE;

	if ((file.dsize > 0 &&
	     fwrite (file.dptr, file.dsize, 1, reconst_out) != 1) ||
	    fclose (reconst_out))
	  return FALSE;

	return TRUE;
      }
    case UNCOMPRESS_GZIP:
      return recompress_gzfile (file, name);
    case UNCOMPRESS_RPM30:
      return recompress_rpm30file (file, name);
    case UNCOMPRESS_AR:
      return recompress_arfile (file, name);
	}

  return FALSE;
}

static MappedFile*
map_gzfile (const gchar *filename)
{
  MappedFile *map;
  gzFile* it = gzopen (filename, "rb");
  int t_read = 0;
  char* n_seg = g_new (char, BUFSIZ);
  int n_seg_len = BUFSIZ;

  if (!it)
    return NULL;

  if (! gzread_and_alloc (&n_seg, &n_seg_len, &t_read, it))
    return NULL;

  if (gzclose (it) != Z_OK)
    return FALSE;

  map = new_map (n_seg, t_read);

  return map;
}

static gint
recompress_gzfile (datum file, const char* name)
{
  gzFile *it = gzopen (name, "wb6");

  if (gzwrite (it, file.dptr, file.dsize) != file.dsize)
    return FALSE;

  if (gzclose (it) != Z_OK)
    return FALSE;

  return TRUE;
}

#endif
