/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ObjectReference;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.ObjectStore;
import jde.debugger.Rep;
import jde.debugger.command.DebugProcessCommand;

public class GetObjectMonitors
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.args.size() != 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(this.args.remove(0), "object ID");
        ObjectStore store = this.proc.getStore();
        ObjectReference oRef = store.get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such object exists");
        }
        this.jde.signalCommandResult(this.procID, this.cmdID, Rep.getObjectMonitorsRep(oRef, store));
    }

    public Object clone() {
        return new GetObjectMonitors();
    }
}

