/*
 *	xeno_theme_enums.h:
 */

#ifndef XENO_THEME_ENUMS
#define XENO_THEME_ENUMS

#include "xeno_theme_main.h"

/*
 *	XenoShadowType
 */
typedef enum {
	XENO_SHADOW_NONE		= GTK_SHADOW_NONE,			/* 0	none	*/
	
	XENO_SHADOW_IN			= GTK_SHADOW_IN,			/* 1	in		*/
	XENO_SHADOW_OUT			= GTK_SHADOW_OUT,			/* 2	out		*/
	
	XENO_SHADOW_ETCHED_IN	= GTK_SHADOW_ETCHED_IN,		/* 3	etched in	*/
	XENO_SHADOW_ETCHED_OUT	= GTK_SHADOW_ETCHED_OUT,	/* 4	etched out	*/
	
	XENO_SHADOW_XENO_IN,		/* default in	*/
	XENO_SHADOW_XENO_OUT,		/* default out	*/
	
	XENO_SHADOW_THIN_IN,		/* thin in		*/
	XENO_SHADOW_THIN_OUT,		/* thin out		*/
	
	XENO_SHADOW_NEXT_IN,		/* next in		*/
	XENO_SHADOW_NEXT_OUT,		/* next out		*/
	
	XENO_SHADOW_NOTE_IN,		/* note in		*/
	XENO_SHADOW_NOTE_OUT,		/* note out		*/
	
	XENO_SHADOW_BLACK_IN,		/* black in		*/
	XENO_SHADOW_BLACK_OUT,		/* black out	*/
	
	XENO_SHADOW_LAST,
	
	/* aliases */
	XENO_SHADOW_BUTTON_RELIEF	= XENO_SHADOW_BLACK_OUT,
	XENO_SHADOW_NOTE			= XENO_SHADOW_NOTE_OUT,
	XENO_SHADOW_THIN_BUTTON_IN	= XENO_SHADOW_NOTE_IN,
	XENO_SHADOW_BUTTON_IN		= XENO_SHADOW_NOTE_IN,
	XENO_SHADOW_MENU			= XENO_SHADOW_OUT,
	XENO_SHADOW_FOCUS			= XENO_SHADOW_BLACK_IN
} XenoShadowType;

#define XENO_SHADOW_IS_IN(shadow)	((shadow) & 0x01)
#define XENO_SHADOW_USER(shadow)	(shadow)

/*
 *	XenoKnobType
 */
typedef enum {
	XENO_KNOB_NONE = 0,
	
	XENO_KNOB_SHADOW_IN			= XENO_SHADOW_IN,
	XENO_KNOB_SHADOW_OUT		= XENO_SHADOW_OUT,
	XENO_KNOB_SHADOW_ETCHED_IN	= XENO_SHADOW_ETCHED_IN,
	XENO_KNOB_SHADOW_ETCHED_OUT	= XENO_SHADOW_ETCHED_OUT,
	XENO_KNOB_SHADOW_THIN_IN	= XENO_SHADOW_THIN_IN,
	XENO_KNOB_SHADOW_THIN_OUT	= XENO_SHADOW_THIN_OUT,
	
	XENO_KNOB_DIMPLE_IN,
	XENO_KNOB_DIMPLE_OUT,
	XENO_KNOB_LINES_IN,
	XENO_KNOB_LINES_OUT,
	XENO_KNOB_BUDS_IN,
	XENO_KNOB_BUDS_OUT,
	
	XENO_KNOB_NS_BUDS_IN,
	XENO_KNOB_NS_BUDS_OUT,
	
	XENO_KNOB_END,
	
	/* aliases */
	XENO_KNOB_DIMPLE	= XENO_KNOB_DIMPLE_IN,
	XENO_KNOB_LINES		= XENO_KNOB_LINES_OUT,
	XENO_KNOB_HOLES		= XENO_KNOB_BUDS_IN,
	XENO_KNOB_BUDS		= XENO_KNOB_BUDS_OUT,
	XENO_KNOB_BOX		= XENO_KNOB_SHADOW_ETCHED_IN,
	XENO_KNOB_DEFAULT	= XENO_KNOB_NS_BUDS_OUT,
	
	XENO_KNOB_SHADOW_LAST = XENO_KNOB_SHADOW_THIN_OUT,
	XENO_KNOB_LAST		  = XENO_KNOB_END - 1
} XenoKnobType;

/*
 *	Images
 */
typedef enum {
	XENO_IMAGE_RADIO_NORMAL_OUT,
	XENO_IMAGE_RADIO_PRELIGHT_OUT,
	XENO_IMAGE_RADIO_INSENSITIVE_OUT,
	XENO_IMAGE_RADIO_NORMAL_IN,
	XENO_IMAGE_RADIO_PRELIGHT_IN,
	XENO_IMAGE_RADIO_INSENSITIVE_IN,
	XENO_IMAGE_RADIO_ACTIVE_IN,
	
	XENO_IMAGE_RADIO_MENU_NORMAL,
	XENO_IMAGE_RADIO_MENU_PRELIGHT,
	XENO_IMAGE_RADIO_MENU_INSENSITIVE,
	
	XENO_IMAGE_NOTEBOOK_CORNER_NORMAL,
	XENO_IMAGE_NOTEBOOK_CORNER_ACTIVE,
	XENO_IMAGE_NOTEBOOK_CORNER_INSENSITIVE,
	
	XENO_IMAGE_DIMPLE_NORMAL,
	XENO_IMAGE_DIMPLE_PRELIGHT,
	XENO_IMAGE_DIMPLE_INSENSITIVE,

	XENO_IMAGE_CHECK_BUTTON_7_NORMAL,
	XENO_IMAGE_CHECK_BUTTON_7_PRELIGHT,
	XENO_IMAGE_CHECK_BUTTON_7_INSENSITIVE,
	XENO_IMAGE_CHECK_BUTTON_7_ACTIVE,
	XENO_IMAGE_CHECK_BUTTON_9_NORMAL,
	XENO_IMAGE_CHECK_BUTTON_9_PRELIGHT,
	XENO_IMAGE_CHECK_BUTTON_9_INSENSITIVE,
	XENO_IMAGE_CHECK_BUTTON_9_ACTIVE,
	XENO_IMAGE_CHECK_BUTTON_11_NORMAL,
	XENO_IMAGE_CHECK_BUTTON_11_PRELIGHT,
	XENO_IMAGE_CHECK_BUTTON_11_INSENSITIVE,
	XENO_IMAGE_CHECK_BUTTON_11_ACTIVE,
	
	XENO_IMAGE_CHECK_MENU_7_NORMAL,
	XENO_IMAGE_CHECK_MENU_7_PRELIGHT,
	XENO_IMAGE_CHECK_MENU_7_INSENSITIVE,
	XENO_IMAGE_CHECK_MENU_9_NORMAL,
	XENO_IMAGE_CHECK_MENU_9_PRELIGHT,
	XENO_IMAGE_CHECK_MENU_9_INSENSITIVE,
	XENO_IMAGE_CHECK_MENU_11_NORMAL,
	XENO_IMAGE_CHECK_MENU_11_PRELIGHT,
	XENO_IMAGE_CHECK_MENU_11_INSENSITIVE,

	XENO_IMAGE_LAST
} XenoImageType;

/*
 *	Image variants, FIXME: unimplemented
 */
enum {
	XENO_CHECK_IMAGE_SMALL,
	XENO_CHECK_IMAGE_NORMAL,
	XENO_CHECK_IMAGE_BIG,
	XENO_CHECK_IMAGE_PERKELE,
	
	XENO_CHECK_IMAGE_LAST
};

enum {
	XENO_RADIO_IMAGE_IN_OUT,
	XENO_RADIO_IMAGE_IN,
	XENO_RADIO_IMAGE_OUT,
	
	XENO_RADIO_IMAGE_LAST
};

enum {
	XENO_DIMPLE_IMAGE_OUT,
	XENO_DIMPLE_IMAGE_IN,
	
	XENO_DIMPLE_IMAGE_LAST
};

typedef enum {
	XENO_ARROW_IMAGE_SHADOW,
	XENO_ARROW_IMAGE_EQUAL,
	XENO_ARROW_IMAGE_NEXT,
	
	XENO_ARROW_IMAGE_LAST
} XenoArrowVariant;


/*
 *	XenoPopupType - for GtkOptionMenu FIXME: unused
 */
typedef enum {
	XENO_POPUP_BOX,
	XENO_POPUP_ARROWS,
	
	XENO_POPUP_DEFAULT = XENO_POPUP_ARROWS,
} XenoPopupType;


#endif /* XENO_THEME_ENUMS */

