/*
 * Copyright (c) 2006 Alvaro Lopes <alvieboy@alvie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pin_helper.h"

static void
pin_helper_pin_entry_callback( GtkDialog *dlg, int response, pin_dialog_t *dialog )
{
    if ( response == GTK_RESPONSE_ACCEPT ) {

	const gchar *pin = gtk_entry_get_text( GTK_ENTRY(dialog->entry) );

	if (!pin || strlen(pin)!=4 )
	{
	    /* Error. */
	    xfce_warn(_("Invalid PIN entered. PIN has 4 digits"));

            return;
	}

        /* cellmodem_t_send_pin( dialog->monitor, pin ); */
        dialog->cb( pin, dialog->pvt );


    } else {
	/*
	 now what???????

	 Wait for user to get to preferences again.

	*/

    }

    gtk_widget_destroy( GTK_WIDGET(dlg) );
    g_free( dialog );
}

void pin_helper_launch( GtkWidget *parent, pin_helper_callback cb, void *pvt )
{
    GtkWidget *vbox;
    GtkWidget *label;
    pin_dialog_t *dialog;

    dialog = g_new0( pin_dialog_t, 1 );

    dialog->pvt = pvt;
    dialog->cb = cb;

    dialog->dlg = gtk_dialog_new_with_buttons ( _("Enter PIN"),
					       GTK_WINDOW( gtk_widget_get_toplevel( parent ) ),
					       GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
					       GTK_STOCK_OK,
					       GTK_RESPONSE_ACCEPT,
					       GTK_STOCK_CANCEL,
					       GTK_RESPONSE_REJECT,
					       NULL
					      );

    vbox = gtk_vbox_new( FALSE, BORDER );
    gtk_widget_show( vbox );
    label = gtk_label_new( _("Please enter PIN:") );
    gtk_widget_show( label );

    gtk_box_pack_start( GTK_BOX(vbox), label, FALSE, FALSE, 0 );

    gtk_box_pack_start( GTK_BOX( GTK_DIALOG(dialog->dlg)->vbox ), vbox, FALSE, FALSE, 0);

    dialog->entry = gtk_entry_new_with_max_length( 4 );
    gtk_entry_set_visibility( GTK_ENTRY( dialog->entry ), FALSE );

    gtk_widget_show( dialog->entry );

    gtk_box_pack_start( GTK_BOX(vbox), dialog->entry, FALSE, FALSE, 0 );



    /* Connect close and response */

    g_signal_connect (dialog->dlg, "close", G_CALLBACK (gtk_widget_destroy), dialog);
    g_signal_connect (dialog->dlg, "response", G_CALLBACK (pin_helper_pin_entry_callback), dialog);

    gtk_widget_show( dialog->dlg );
}
