/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "add_file.h"
#include "entry.h"
#include "touch.h"
#include "misc.h"
#include "monitor.h"
#include "widgets.h"


void on_touch_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tree_entry_t *en;
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter iter;
    char path[_POSIX_PATH_MAX];


    if(!set_load_wait(&tree_details))
	return;
    en = get_selected_entry(treeview, &iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status(treeview, "xf_ERROR_ICON", strerror(EINVAL), NULL);
	return;
    }
    {
	char *argv[4];
	int status;
	pid_t child;
	argv[0] = "touch";
	argv[1] = path;
	strcpy(path, en->path);
	argv[2] = 0;
	child = fork();
	if(child < 0)
	    g_assert_not_reached();
	if(!child)
	{
	    execvp(argv[0], argv);
	    _exit(1);
	}
	usleep(50000);
	wait(&status);
    }

    {
	struct stat st;
	gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	stat(en->path, &st);
	memcpy(en->st, &st, sizeof(struct stat));
	update_columns(treemodel, &iter, en);
    }
    unset_load_wait(&tree_details);
    return;
}
