<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- This file is part of xgridfit.
       It is distributed under the GNU Public License, version 2.
       Copyright (c) 2006-7 by Peter S. Baker
  -->

  <xsl:template match="if">
    <xsl:param name="call-macro-param-set"/>
    <xsl:call-template name="push-value">
      <xsl:with-param name="val" select="@test"/>
      <xsl:with-param name="call-macro-param-set"
		      select="$call-macro-param-set"/>
    </xsl:call-template>
    <xsl:call-template name="simple-command">
      <xsl:with-param name="cmd" select="'IF'"/>
    </xsl:call-template>
    <xsl:apply-templates>
      <xsl:with-param name="call-macro-param-set"
		      select="$call-macro-param-set"/>
    </xsl:apply-templates>
    <xsl:call-template name="simple-command">
      <xsl:with-param name="cmd" select="'EIF'"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="else">
    <xsl:param name="call-macro-param-set"/>
    <xsl:choose>
      <xsl:when test="parent::if">
	<xsl:call-template name="simple-command">
	  <xsl:with-param name="cmd" select="'ELSE'"/>
	</xsl:call-template>
	<xsl:apply-templates>
	  <xsl:with-param name="call-macro-param-set"
			  select="$call-macro-param-set"/>
	</xsl:apply-templates>
      </xsl:when>
      <xsl:when test="parent::compile-if">
	<xsl:apply-templates>
	  <xsl:with-param name="call-macro-param-set"
			  select="$call-macro-param-set"/>
	</xsl:apply-templates>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="compile-if-test">
    <xsl:param name="test"/>
    <xsl:param name="call-macro-param-set"/>
    <xsl:choose>
      <xsl:when test="not($test)">
	<xsl:value-of select="1"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:variable name="v">
	  <xsl:call-template name="get-number-literal">
	    <xsl:with-param name="val" select="$test"/>
	    <xsl:with-param name="call-macro-param-set"
			    select="$call-macro-param-set"/>
	  </xsl:call-template>
	</xsl:variable>
	<xsl:choose>
	  <xsl:when test="number($v)">
	    <xsl:value-of select="1"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:value-of select="0"/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="compile-if">
    <xsl:param name="call-macro-param-set"/>
    <xsl:variable name="text-num">
      <xsl:call-template name="get-number-literal">
	<xsl:with-param name="val" select="@test"/>
	<xsl:with-param name="call-macro-param-set"
			select="$call-macro-param-set"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:if test="not(number($text-num)) and number($text-num) != 0">
      <xsl:call-template name="error-message">
	<xsl:with-param name="msg">
	  <xsl:text>Cannot resolve attribute test="</xsl:text>
	  <xsl:value-of select="@test"/>
	  <xsl:text>" in &lt;compile-if&gt;</xsl:text>
	</xsl:with-param>
      </xsl:call-template>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="number($text-num)">
	<xsl:apply-templates>
	  <xsl:with-param name="call-macro-param-set"
			  select="$call-macro-param-set"/>
	</xsl:apply-templates>
      </xsl:when>
      <xsl:when test="else">
	<xsl:apply-templates select="else">
	  <xsl:with-param name="call-macro-param-set"
			  select="$call-macro-param-set"/>
	</xsl:apply-templates>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
