/* 
 * Copyright (C) 2000 Rich Wareham <richwareham@users.sourceforge.net>
 * 
 * This file is part of libdvdnav, a DVD navigation library.
 * 
 * libdvdnav is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * libdvdnav is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: searching.c,v 1.7 2002/01/09 00:54:22 jcdutton Exp $
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <dvdnav.h>
#include "dvdnav_internal.h"

#include "vm.h"
#include <dvdread/nav_types.h>

/* Searching API calls */

dvdnav_status_t dvdnav_time_search(dvdnav_t *self,
				   unsigned long int time) {
  return S_OK;
}

dvdnav_status_t dvdnav_part_search(dvdnav_t *self, int part) {
  return S_OK;
}

dvdnav_status_t dvdnav_prev_pg_search(dvdnav_t *self) {
  dvd_state_t *state;
  state = &(self->vm->state);
  /* Make sure this is not the first chapter */
  
  if(state->pgN <= 1 ) {
    printf("dvdnav: at first chapter. prev chapter failed.\n");
    return S_ERR;
  }
  printf("dvdnav: previous chapter\n");
  vm_jump_prog(self->vm, state->pgN - 1);
  dvdnav_do_post_jump(self);
  printf("dvdnav: previous chapter done\n");

  return S_OK;
}

dvdnav_status_t dvdnav_top_pg_search(dvdnav_t *self) {

  printf("dvdnav: top chapter. NOP.\n");
  
  return S_OK;
}

dvdnav_status_t dvdnav_next_pg_search(dvdnav_t *self) {
  dvd_state_t *state;
  state = &(self->vm->state);
  /* Make sure this is not the last chapter */
  if(state->pgN >= state->pgc->nr_of_programs) {
    printf("dvdnav: at last chapter. next chapter failed.\n");
    return S_ERR;
  }
  printf("dvdnav: next chapter\n");
  vm_jump_prog(self->vm, state->pgN + 1);
  dvdnav_do_post_jump(self);
  printf("dvdnav: next chapter done\n");

  return S_OK;
}

dvdnav_status_t dvdnav_menu_call(dvdnav_t *self, DVDMenuID_t menu) {
  dvd_state_t *state;

  pthread_mutex_lock(&self->vm_lock); 
  state = &(self->vm->state);
  vm_menu_call(self->vm, menu, 0); 
  dvdnav_do_post_jump(self);
  pthread_mutex_unlock(&self->vm_lock); 
  return S_OK;
}

dvdnav_status_t dvdnav_current_title_info(dvdnav_t *self, int *title,
			     		  int *part) {
  return S_OK;
}

static char __title_str[] = "DVDNAV";

dvdnav_status_t dvdnav_get_title_string(dvdnav_t *self, char **title_str) {
  if(!self)
   return S_ERR;

  if(!title_str) {
    printerr("Passed a NULL pointer");
    return S_ERR;
  }

  (*title_str) = __title_str;

  return S_OK;
}

dvdnav_status_t dvdnav_get_position(dvdnav_t *self, unsigned int* pos,
				    unsigned int *len) {
  uint32_t cur_sector;
  uint32_t first_cell_nr;
  uint32_t last_cell_nr;
  cell_playback_t *first_cell;
  cell_playback_t *last_cell;
  dvd_state_t *state;

  if((!self) || (!self->vm) )
   return 0;
  
  state = &(self->vm->state);
 
  /* Sanity check */
  if(state->pgN > state->pgc->nr_of_programs) {
    return 0;
  }
  
  /* Get current sector */
  cur_sector = self->vobu_start + state->blockN;

  /* Find start cell of program. */
  first_cell_nr = state->pgc->program_map[state->pgN-1];
  first_cell = &(state->pgc->cell_playback[first_cell_nr-1]);
  if(state->pgN < state->pgc->nr_of_programs) {
    last_cell_nr = state->pgc->program_map[state->pgN] - 1;
  } else {
    last_cell_nr = state->pgc->nr_of_cells;
  }
  last_cell = &(state->pgc->cell_playback[last_cell_nr-1]);

  *pos= cur_sector - first_cell->first_sector;
  *len= last_cell->last_sector - first_cell->first_sector;
  /* printf("dvdnav:searching:current pos=%u length=%u\n",*pos,*len); */


  return S_OK;
}

