
if ($#ARGV < 0)
{
    print STDERR 
	" $$: $0  @ARGV
 DESCRIPTION
  the primary output stream is converted to html4-style, that is
  we provide a header and footer and may include a css-stylesheet,
  that can be given as -css=file. If the input contains xm-format
  markups in all-uppercase, they are always converted to font-classes
  whose outline can be given in the css-stylesheet.

   note: with the uppercase-notion, this perlcode does not need to have 
   any special knowledge about the html-outline of the markups in use.
   
  special extension: 
      if the .css contains declarations of the form 
          pre.FORMAT { ... background-color: ... }
      then a <pre>-section is generated instead of a <span>-section and
      the <pre>-section is surrounded by a 100\%-table with background
      given in the pre... (netscape4 does loose with nested-<pre>s when
      somewhere there was a <td>s with a class).
";
    exit(0);
}
my %o;

sub c2x_cdefs_html4
{
    my $in = shift;
    my $css = shift;
    
    %cssTD = ();
    if (defined $css and length $css)
    {
        $css =~ s{ \bpre\b\ *\.(\w+) \s*\{ }
            { $cssTD{$1} = ""; print STDERR "/$1/" if defined $o{v}; $& }gsex;

        $css =~ s{ \bpre\b\ *\.(\w+) \s*\{ [^\{\}]* \b background-color:\ * ([^\ \;\{\}]*) [\ \;\{\}] }
            { $cssTD{$1} .= " bgcolor=\"$2\""; $& }gsex;
    }
    
    # first the links...

    $in =~ s{ (<([A-Z]+)\b[^<>]*\bid=\"([^\"<>]*)\"[^<>]*>) } # a name-markup is in an opening-xm markup
        	{ "<a name=\"$3\">$1" }gsex;

    $in =~ s{ (<([A-Z]+)\b[^<>]*\blinkend=\"([^\"<>]*)\"[^<>]*>) ((?:.(?!</?\2\b))*.) (</\2\b[^<>]*>) } 
        	{ "<a href=\"#$3\">".$1.$4.$5."</a>" }gsex;

    $in =~ s{ (<([A-Z]+)\b[^<>]*\burl=(\"[^\"<>]*\")[^<>]*>) ((?:.(?!</?\2\b))*.) (</\2\b[^<>]*>) } 
        	{ "$1<a href=\"$3\">".$1.$4.$5."</a>" }gsex;

    # last the spans...
  
    $in =~ s{ <([A-Z]+)\b(\s*\w*)> } 
        	{ exists $cssTD{$1} 
                    ? "<table width=\"100\%\" $cssTD{$1}><tr><td><pre class=\"$1\" $2>"
                    : "<span class=\"$1\" $2>"
                }gsex;
    $in =~ s{ </([A-Z]+)\b(\s*\w*)> }
        	{ exists $cssTD{$1}
                    ? "</pre></td></tr></table>"
                    : "</span>"
                }gsex;

    $in =~ s{ <([A-Z]+)\b(\s*\w*=[^<>]*)> } 
        	{ exists $cssTD{$1} 
                    ? "<table width=\"100\%\" $cssTD{$1}><tr><td><pre class=\"$1\" $2>"
                    : "<span class=\"$1\" $2>"
                }gsex;
    $in =~ s{ </([A-Z]+)\b(\s*\w*=[^<>]*)> }
        	{ exists $cssTD{$1}
                    ? "</pre></td></tr></table>"
                    : "</span>"
                }gsex;

    
    return $in;
}

my $T = "";
for (@ARGV)
{
    if (/^-$/) { $T .= join ("",<STDIN>); }
    elsif (/^-([\w-]+)=(.*)/) { $o{$1} = $2; }
    elsif (/^-([\w-]+)/) { $o{$1} = ""; }
    else {
	my $F = $_; 
	if (open F, "<$F") { $T .= join("",<F>); close F; $o{"/file"} = $F; }
	else { die "could not open $F", $1; }
    }
}

if (not (exists $o{q} or exists $o{quiet}) )
{
    print $T;
}

if (length $T)
{
    my $F;
    my $css = "";

    $o{"/program"} = $0;
    $o{"/css"} = $o{"/program"}; $o{"/css"} =~ s{\.\w+$} {\.css};
    $o{css} = $o{"/css"} if not defined $o{css};
    $F = $o{css};
    if (-f $F)
    {
        if (open F,"<$F")
        {
            $css = join("",<F>);
            close F;
        }
    }else{
        print STDERR "<no css-file \"$F\">" if defined ${v};
    }
    
    $o{"/file"} = "a" if not defined $o{"/file"};
    $o{o} = $o{"/file"}.".xm" if not defined $o{o};
    my $F = $o{o};

    if (open F, ">$F")
    {
        print F "<html><head>\n";
        if (length $css) { 
            my $date = `date`;
            print F "<!-- generated by ",$0," : ",chomp($date),"-->\n";
            print F "<style>\n".$css."\n</style>\n"; 
        }
        print F "</head><body>\n";
        
        print F "<pre>".c2x_cdefs_html4($T,$css)."</pre>\n";
    
        print F "</body></html>";
    }else{
        print STDERR "<could not open \"$F\">" if defined ${v};
    }
}

