package xm::listing;
use strict;
use xm::o;
use xm::sub;

sub DESC
{"
  will look for all texts that are inside <whateverListing>-markups
  and replace the inner with their xm::off version of being
  purely literal as a whole.
"}

sub ARGS { return xm::o::args_stdin(@_, DESC); }

sub DO
{
    my $in = shift;

    my $x = sub { 
	my ($a,$b) = @_;
	if ($b !~ m/<CPRE>\s*\#\s*include\b/s)  
	{  
	    return $a.$b;
	}else{  
	    return $a."<ITEMINCL>".$b."</ITEMINCL>";
	}
    };

    # whateverListing
    $in =~ s{(<(\w+Listing)\b[^<>]*>(?!</?\2\b))
		 ( (?:.(?!</?\2\b))*. )(</\2\b)
		     } 
         { 
	     $1.&xm::sub::off($3).$4
	 }gsex;
    # whateverLISTING
    $in =~ s{(<(\w+LISTING)\b[^<>]*>(?!</?\2\b))
		 ( (?:.(?!</?\2\b))*. )(</\2\b)
		     } 
         { 
	     $1.&xm::sub::off($3).$4
	 }gsex;
    return $in;
} 

1;



