package xm::mreads;
use strict;
use xm::o;

sub DESC
{"
  take a normal text file that is structured like a mime header,
  ie. a new section is started with the name of the section
  starting in column one and streching to a colon. Following
  lines are read until the next mime-section is encountered.

  This one converts it into xml'ish, which would be 
  almost like calling xm::sub.off on the complete source text.
  (xm::sub.off replaces  the special-chars [\&<>\"] with their entity-refs). 
 
  The xm-tags will just get the section name, ie.
        |Subject: Hello
        |Content-Type: multipart/alternative;
        |  boundary=\"---somerandomnumber\"
  is converted to
        |<Subject> Hello</Subject>
        |<Content-Type> multipart/alternative;
        |  boundary=&quot;---somerandomnumber&quot;</Content-Type>

  see xm::pp for possibilites for further processing with xm'ish
  tools. You can use xm::sub::un_quote or xm::sub::on on the 
  enclosed portin to scan it more traditionally.
"}

sub ARGS { return xm::o::args_stdin(@_,DESC); }

sub DO 
{
    my ($in,$before) = @_;
    $before = "FILEHEADER" if not length $before;

    print STDERR "have ".(length $in)." text\n";

    # xm::sub::off
    $in =~ s{\&} {\&amp;}gs;
    $in =~ s{\<} {\&lt;}gs;
    $in =~ s{\>} {\&gt;}gs;
    $in =~ s{\"} {\&quot;}gs;

    # convert section marks to xm markups
    # a section must have atleast start with a \w-char and must end with one
    # that is, it must have atleast one \w-char
    $in =~ s{(^)(\w[\w\-\.\/]*\b)(:)} {$1<$2>}gm; # mark start of section
    $in =~ s{(^)<(\w[^<>]*)>([^<>]*)} 
	{my $o = $3; chomp $o;	"$1<$2>$o</$2>\n" }gme; # end section
    if ($in !~ /^</s)
    {
       $in =~ s{(^)([^<>]*)} 
	{my $o = $2; chomp $o; 
	 $o = "$1<$before>$o</$before>\n" if length $o;
	 $o
	}se; # prequel
    }
    
    print STDERR "done ".(length $in)." text\n";
    return $in;
}

1;

