package xm::navheaderhrefsfromindex;
use strict;
use xm::o;

sub DESC
{"
  interpret the input as an index.xml file that is supposed to
  be converted to an index.html, and which has therefore some
  href-attributes around a title-saying text.
  Scan this index.xml, make a table in the order of the hrefs'n'items,
  and open each references xml-file to attach a navheader with
  hrefs for next,index,prev.
  see xm::pfe::wordset2index and xm::pfe::words2index for the
  preceding stage that generates xml-files and an index.xml file
  which are each supposed to be converted to html.
"}

sub ARGS { return xm::o::args_command(@_,DESC); }

sub makeheader
{
    my $index = shift; # the index-file itself

    #### is the index in fact a subdir with files ?
    my $dir = ".";

    if (-d $index)
    {
	$dir = $index;
	$index = "index.xml" ; # ouch... more detection needed here...
    }

    #### detect the file-extension in use at this stage of processing
    my $xml = "xml";

    if ($index =~ m{ (.*)\.(\w+)$ }x)
    {
	$xml = $2;
	$index = $1;
    }

    #### open the index and slurp it in
    my $F;
    my $in;

    $F = "$dir/$index.$xml";
    return "" if not open F,"<$F";
    $in = join("",<F>);
    close F;

    ### first, detect the markup that we can find the hrefs in..
    my $markup = "a";

    if ($in =~ m{ <(\w\w+\b)[^<>]*\bhref=\"[^<>\"]*\"[^<>]*>
		      ((?:.(?!</?\1\b))*.)
			  </\1[^<>]*\bhref\b[^<>]*> }sx)
    {
	$markup = $1;
	print STDERR ":",$markup,":";
    }else{
	print STDERR "warning: no xml-markup for hrefs found, using <a>";
    }

    ### build the nav-arrayhash

    my %nav;
    my $i = 10000;

    $in =~ s{ <($markup)\b[^<>]* href=\"([^<>\"]*)\"[^<>]*>
		  ((?:.(?!</?\1\b))*.)
		      </\1[^<>]*> }
    {
	$nav{"c".$i}{file} = $2;
	$nav{"c".$i}{text} = $3;
	$nav{"c".$i}{name} = $3;
	$i++;
	""
	}sgex;

    print STDERR scalar %nav,":";

    $nav{a}{file} = "$index.html";
    $nav{e}{file} = "$index.html";
    $nav{a}{text} = "     ";
    $nav{e}{text} = "     ";
    $nav{a}{name} = "index";
    $nav{e}{name} = "index";
    
    # clean the names

    my $k;
    for $k (keys %nav)
    {
	$nav{$k}{name} =~ s{<[^<>]*>}{}sg;
	$nav{$k}{name} =~ s{\<\>\"}{}sg;
	$nav{$k}{name} =~ s{\s+}{ }sg;
	$nav{$k}{name} =~ s{ ^\s }{}x;
	$nav{$k}{name} =~ s{ \s$ }{}x;
	$nav{$k}{text} =~ s{ ^\s }{}x;
	$nav{$k}{text} =~ s{ \s$ }{}x;
    }

    ### set the next/prev entries

    $i = "a";
    for $k (sort keys %nav)
    {
	$nav{$k}{prev} = $i;
	$i = $k;
    }

    $i = "e";
    for $k (reverse sort keys %nav)
    {
	$nav{$k}{next} = $i;
	$i = $k;
    }

    ### open each file and add the header
    my $out = "";

    for $k (sort keys %nav)
    {
	next if $k !~ /\d/; # but not the index-file itself

	$F = $dir."/".$nav{$k}{file};
	$F =~ s{ \.\w+$ } {".".$xml}sex;

	next if not open F, "<$F";
	$in = join ("",<F>);
	close F;

	next if $in =~ /<NAVHEADER>/; # do not do it twice

	$out = "<NAVHEADER><NAVTITLE>".$nav{$k}{text}."</NAVTITLE>\n";
	$out .= "<NAVPREV href=\"".$nav{ $nav{$k}{prev} }{file}."\">"
	    .$nav{ $nav{$k}{prev} }{name}."</NAVPREV href>\n";
	$out .= "<NAVNEXT href=\"".$nav{ $nav{$k}{next} }{file}."\">"
	    .$nav{ $nav{$k}{next} }{name}."</NAVNEXT href>\n";
	$out .= "</NAVHEADER><NAVBODY>\n";
	$out .= $in;
	$out .= "</NAVBODY>";

	next if not open F, ">$F";
	print STDERR $F,",";
	print F $out;
	close F;
    }

    return $dir."/".$index.".".$xml;
}

sub DO
{
    my $args = $_[0];
    my $the;
    my $out;
    for $the (@$args)
    {
	$out .= makeheader($the);
	$out .= "\n";
    }
    return $out;
}

1;

