use strict;
use xm::o;

xm::o::argv_stdin("converting a xm-hashtable to a html-table with 2 columns");

# the first field in the xm-database is used for the big cell.

sub detect_fields
{
    my $text = shift;
    my $field = shift;
    
    $text =~ s{ <([A-Z]+)\b[^<>]*> (?:.(?!</?\1\b))*. </\1\b[^<>]*> }
             { push @{$field}, $1; "" }gsex;
}

if (length $o{" "})
{
    local $_ = $o{" "};
    my $itemsep;
    my @fields;
    /^[^<>]*<([A-Z]+)\b/sx && do { $itemsep = $1; };
    
    /^<$itemsep\b[^<>]*> ((?:.(?!<\/?$itemsep\b))*.) <\/$itemsep\b[^<>]*>/sx
    &&  detect_fields($1, \@fields);
    
    if(1) # if ($#fields > 0)
    {
        my $f0 = $fields[0];
        my $f1 = $fields[1];
        print "<html>";
        print "<title>",$itemsep;
        print ": ",$o{title} if exists $o{title};
        print "</title>\n";
        print "<body bgcolor=\"#D0D0D0\">";
        print "<h2 align=center>",$itemsep;
        print ": ",$o{title} if exists $o{title};
        print "</h2>\n";
        print "<table width=100\%>\n";
        print "<tr>\n";
        s{<$itemsep\b([^<>]*)>} {"<!-- $itemsep $1 -->"}gsex;
        s{</$itemsep\b([^<>]*)>} {"<!-- / $itemsep -->"}gsex;
        
        my $f;
        for $f (@fields)
        {
            if ($f eq $f0)
            {
                print "<tr><th bgcolor=\"#F0F0F0\" valign=top rowspan=$#fields>",$f,"</th>\n";
                s{<$f\b([^<>]*)>} {"<tr><td$1 bgcolor=white valign=top rowspan=$#fields><pre>"}gsex;
                s{</$f\b([^<>]*)>} {"</pre></td>"}gsex;
            }
            elsif ($f eq $f1)
            {
                print "<th bgcolor=\"#F0F0F0\" valign=bottom align=left>",$f,"</th></tr>\n";
                s{<$f\b([^<>]*)>} {"<td$1 bgcolor=white valign=bottom><pre>"}gsex;
                s{</$f\b([^<>]*)>} {"</pre></td></tr>"}gsex;
            }
            else
            {
                print "<tr><th bgcolor=\"#F0F0F0\" valign=top align=left>",$f,"</th></tr>\n";
                s{<$f\b([^<>]*)>} {"<tr><td$1 bgcolor=white valign=top><pre>"}gsex;
                s{</$f\b([^<>]*)>} {"</pre></td></tr>"}gsex;
            }
        }
    
        print $_;
        print "</table>\n";
        my $user = do { `id -un` }; 
        print "<p>",`date`,", ",$user,"</p>";
        print "\n</body></html>";
    }
}

