package xm::umlaut;
use strict;
use xm::o;

sub DESC
{"
  will look for twochar markup, then look into xm{umlaut}, and if
  found there, replace the umlaut with the coresponding text.
"}

sub ARGS { return xm::o::args_stdin(@_, DESC); }

$xm{umlaut} = 
{
    ae => "&auml;",	Ae => "&Auml;",
    ee => "&euml;",	Ae => "&Euml;",
    oe => "&ouml;",	Oe => "&Ouml;",
    ue => "&uuml;",	Ue => "&Uuml;",
    ss => "&szlig;",    Ss => "ss",  SS => "SS",
    ai => "&aacute;",   Ai => "&Aacute",
    ei => "&eacute;",   Ei => "&Eacute",
    oi => "&oacute;",   Oi => "&Oacute",
    ui => "&uacute;",   Ui => "&Uacute",
    yi => "&yacute;",   Yi => "&Yacute",
    mu => "&micro;",    Yi => "&Yacute",
};

sub DO
{
    my $in = shift;

    my $x = sub {
	my ($a,$b,$c) = @_;
	return $a.$b.$c if not exists $xm{umlaut}{$b};
	return $xm{umlaut}{$b};
    };

    # whatever
    $in =~ s{(<)(\w.)(>)} {&$x($1,$2,$3)}gsex;

    return $in;
} 

1;



