/*
 *  XMMS Crossfade Plugin
 *  Copyright (C) 2000-2001  Peter Eisenlohr <p.eisenlohr@gmx.net>
 *
 *  based on the original OSS Output Plugin
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */

/*
 *  FFT playground
 */

#ifndef __FFT_H__
#define __FFT_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "crossfade.h"

#ifdef HAVE_RFFTW_H
#include <rfftw.h>
#else
#error Could not find rfftw.h?!?
#endif

#define FFT_INTERVAL    (44100*500/1000)
#define FFT_SMOOTH_SIZE 8

typedef struct
{
  gboolean   valid;

  gint16     smooth[FFT_SMOOTH_SIZE];
  gint       used;
  gint       ival;

  gint       num_bands;
  rfftw_plan plan;
}
fft_context_t;

void fft_init(fft_context_t *fftc);
void fft_flow(fft_context_t *fftc,
	      gpointer       buffer,
	      gint           length);
void fft_free(fft_context_t *fftc);

#endif  /* _FFT_H_ */
