/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __CPICTURE_H__
#define __CPICTURE_H__

#include <glib.h>

typedef enum PicType
{
	PT_NON = 0,
	PT_RAW,
	PT_TGA,
	PT_BMP,
	PT_SGI,
};

class CPicture
{
public:
	CPicture();
	CPicture(gchar i_bpp, guint32 i_width, guint32 i_height, const gchar *i_data);
	virtual ~CPicture();

	virtual bool loadFile (const gchar *name, PicType i_type);
	virtual bool loadData (const gchar *data_p, const guint size, PicType i_type);
	void free();

	virtual bool setRAW(gchar i_bpp, guint32 i_width, guint32 i_height);

	guint32 getWidth()	{ return width; }
	guint32 getHeight()	{ return height; }
	gchar  getBpp()		{ return bpp; }
	gchar* getData()	{ return data; }
	gint32 getLastError()	{ return lastError; }

	guint32 operator[] (guint32 guint32);

protected:
	gchar    bpp;
	guint32  width;
	guint32  height;
	guint32  size;
	gchar   *data;
	gint32   lastError;
	PicType  type;

	gint32 BMP_ParseBuffer(const gchar *buffer, guint32 buf_size);
	gint32 TGA_ParseBuffer(const gchar *buffer, guint32 buf_size);
	gint32 SGI_ParseBuffer(const gchar *buffer, guint32 buf_size);
	gint32 RAW_ParseBuffer(const gchar *buffer, guint32 buf_size);

	gchar* grabData (const gchar *buff, guint32 size, guint32 fakesize = 0);
	gint32 decodeRLE (const gchar *buffer, guint32 buf_size);
};

#endif // __CPICTURE_H__
