/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "displayer_test_sdl_status.h"
#include "test_sdl_handlers.h"
#include "sdl_helpers.h"

TestSDLStatus displayer_test_sdl_status;

void displayer_test_sdl_status_init(void)
{
	displayer_test_sdl_status.song = NULL;
	displayer_test_sdl_status.update_song = FALSE;

	displayer_test_sdl_status.toggle_yz = FALSE;
	displayer_test_sdl_status.print_debug = FALSE;
	displayer_test_sdl_status.is_fullscreen = FALSE;

	displayer_test_sdl_status.time = 0;
	displayer_test_sdl_status.toplines = 2;
	displayer_test_sdl_status.lines = 5;

	displayer_test_sdl_status.screen = NULL;
	displayer_test_sdl_status.current_text = NULL;
	displayer_test_sdl_status.next_text = NULL;
	displayer_test_sdl_status.font = NULL;

	displayer_test_sdl_status.jump_to_song = -1;
	displayer_test_sdl_status.skd = NULL;

	displayer_test_sdl_status.sdl_inuse = FALSE;

	displayer_test_sdl_status.xmms_playing = FALSE;
	displayer_test_sdl_status.singit_playing = FALSE;

	displayer_test_sdl_status.longest_line = 0;

	displayer_test_sdl_status.render_thread = 0;
	displayer_test_sdl_status.kill_render_thread = FALSE;
}

void displayer_test_sdl_status_finish(void)
{
	if (displayer_test_sdl_status.current_text != NULL) {
		SDL_FreeSurface(displayer_test_sdl_status.current_text);
		displayer_test_sdl_status.current_text = NULL;
	}

	if (displayer_test_sdl_status.next_text != NULL) {
		SDL_FreeSurface(displayer_test_sdl_status.next_text);
		displayer_test_sdl_status.next_text = NULL;
	}

	if (displayer_test_sdl_status.font != NULL) {
		TTF_CloseFont(displayer_test_sdl_status.font);
		displayer_test_sdl_status.font = NULL;
	}

	if (displayer_test_sdl_status.sdl_inuse == FALSE) {
		sdl_helper_blanking(BLANK_RESET);

		tsnh_finish();
	}

	singit_song_detach(&displayer_test_sdl_status.song);

	displayer_test_sdl_status.screen = NULL;
}
