/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __EDITOR_STATUS_H__
#define __EDITOR_STATUS_H__

#include <glib.h>

#include "singit/config_gen.h"
#include "singit/singleton.h"

#ifdef __cplusplus
extern "C" {
#endif // * __cplusplus *

#define TYPE_EDITOR_STATUS            (editor_status_get_type ())
#define EDITOR_STATUS(obj)            (GTK_CHECK_CAST ((obj), TYPE_EDITOR_STATUS, EditorStatus))
#define EDITOR_STATUS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_EDITOR_STATUS, EditorStatus))
#define IS_EDITOR_STATUS(obj)         (GTK_CHECK_TYPE ((obj), TYPE_EDITOR_STATUS))
#define IS_EDITOR_STATUS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_EDITOR_STATUS))

typedef struct _EditorStatus       EditorStatus;
typedef struct _EditorStatusClass  EditorStatusClass;

struct _EditorStatus {

	SingitSingleton          singleton;

	SingitConfigGen         *config;

	gboolean          cleanedUp;
	guint             time_context_id;
	guint             mode_context_id;
	guint             modified_context_id;
	guint             filename_context_id;
	guint             valid_consistency_id;

	gchar            *filename;
	gboolean          is_guessed_filename;
	gboolean          text_changed;
	gboolean          valid_consistency;
	gchar            *changed_spaces;
	gboolean          continue_func;

	gint              strip_html_state;

	gchar            *text;
	gint              text_carret;

	gchar            *last_directory;
};

struct _EditorStatusClass {

	SingitSingletonClass     parent_class;
};

GtkType            editor_status_get_type (void);

// The function returns the singleton and if none exists creates it
SingitSingleton*   editor_status_ref(void);
// The function dereeferences the singleton and frees it,
// if the reference count drops below 1
void               editor_status_unref(SingitSingleton** single);

// The "unsecure" reference function.
// It just returns the singleton object
SingitSingleton*   editor_status_noref(void);

#define EDT_STATUS \
	((editor_status_noref() == NULL) ? NULL : EDITOR_STATUS(editor_status_noref()))

#ifdef __cplusplus
}
#endif // * __cplusplus *

#endif // __EDITOR_STATUS_H__
