#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include <xmms/fullscreen.h>
#include <xmms/configfile.h>
#include "syna_xmms.h"

static GtkWidget *configure_win = NULL;
static GtkWidget *options_fademode_stars, *options_fademode_heat, *options_fademode_wave;
static GtkWidget *options_diamonds;

static GtkWidget *options_brightness, *options_starsize;
static GtkObject *options_brightness_adj, *options_starsize_adj;

static GtkObject *options_fg_green_adj, *options_fg_red_adj;
static GtkObject *options_bg_green_adj, *options_bg_red_adj;

static GtkObject *options_width_adj, *options_height_adj;

static SynXConfig oldconfig;

static guint resizer(gpointer data) {
	SYNX_LOCK();
	if ((!synx_am_fullscreen || !synx_cfg.scale) &&
	    (synx_cfg.req_w != synx_img_w || synx_cfg.req_h != synx_img_h)) {
		synx_resize(synx_cfg.req_w, synx_cfg.req_h, TRUE);
	}
	SYNX_UNLOCK();
	
	return FALSE;
}

static void configure_ok(GtkWidget *w, gpointer data)
{
	synx_write_cfg();
	gtk_widget_destroy(configure_win);
}

static void configure_cancel(GtkWidget *w, gpointer data)
{
	synx_cfg = oldconfig;
	SYNX_LOCK();
	synx_generate_cmap();
	SYNX_UNLOCK();
	syna_setStarSize(synx_cfg.starSize);
	gtk_widget_destroy(configure_win);
	resizer(NULL);
}

static void synx_fademode_toggle_cb(GtkWidget *w, gpointer data) {
	if (GTK_TOGGLE_BUTTON(options_fademode_stars)->active) {
		synx_cfg.fadeMode = Stars;
	} else if (GTK_TOGGLE_BUTTON(options_fademode_heat)->active) {
		synx_cfg.fadeMode = Flame;
	} else {
		synx_cfg.fadeMode = Wave;
	}
	syna_setStarSize(synx_cfg.starSize);
}

static void synx_fullscreen_cb(GtkWidget *w, gpointer data) {
	synx_cfg.auto_fullscreen = GTK_TOGGLE_BUTTON(w)->active;
}

static void diamond_cb(GtkWidget *w, gpointer data) {
	synx_cfg.pointsAreDiamonds = GTK_TOGGLE_BUTTON(options_diamonds)->active;
	syna_setStarSize(synx_cfg.starSize);
}

static void color_changed_cb(GtkWidget *w, gpointer data) {
	synx_cfg.fgRed = GTK_ADJUSTMENT(options_fg_red_adj)->value / 100.0;
	synx_cfg.fgGreen = GTK_ADJUSTMENT(options_fg_green_adj)->value / 100.0;
	synx_cfg.bgRed = GTK_ADJUSTMENT(options_bg_red_adj)->value / 100.0;
	synx_cfg.bgGreen = GTK_ADJUSTMENT(options_bg_green_adj)->value / 100.0;

	SYNX_LOCK();
	synx_generate_cmap();
	SYNX_UNLOCK();
}

static guint resizerid = 0;

static void size_changed_cb(GtkWidget *w, gpointer data) {
	synx_cfg.req_w = GTK_ADJUSTMENT(options_width_adj)->value;
	synx_cfg.req_h = GTK_ADJUSTMENT(options_height_adj)->value;

	if (resizerid) gtk_timeout_remove(resizerid);
	resizerid = gtk_timeout_add(1000, (GtkFunction)resizer, NULL);
}

static void synx_scale_cb(GtkWidget *w, gpointer data) {
	synx_cfg.scale = GTK_TOGGLE_BUTTON(w)->active;
}

static void brightness_cb(GtkWidget *w, gpointer data) {
	synx_cfg.brightnessTwiddler = GTK_ADJUSTMENT(options_brightness_adj)->value / 100.0;
}

static void starsize_cb(GtkWidget *w, gpointer data) {
	synx_cfg.starSize = GTK_ADJUSTMENT(options_starsize_adj)->value / 100.0;
	syna_setStarSize(synx_cfg.starSize);
}

void synx_configure (void)
{
	GtkWidget *vbox, *options_vbox, *options_frame;
	GtkWidget *options_fademode_box;
	GSList *options_fademode_group;
	GtkWidget *options_twiddler_box;
	GtkWidget *bbox, *ok, *cancel;

	GtkWidget *label, *box, *widget;

	if(configure_win)
		return;

	synx_read_config();
	oldconfig = synx_cfg;

	configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_container_set_border_width(GTK_CONTAINER(configure_win), 10);
	gtk_window_set_title(GTK_WINDOW(configure_win), "Synaesthesia-XMMS Configuration");
	gtk_window_set_policy(GTK_WINDOW(configure_win), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(configure_win), GTK_WIN_POS_MOUSE);
	gtk_signal_connect(GTK_OBJECT(configure_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			   &configure_win);

	vbox = gtk_vbox_new(FALSE, 5);

	options_frame = gtk_frame_new("Options:");
	gtk_container_set_border_width(GTK_CONTAINER(options_frame), 5);

	options_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(options_vbox), 5);

	options_fademode_box = gtk_hbox_new(TRUE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(options_fademode_box), 5);
	gtk_box_pack_start(GTK_BOX(options_vbox), options_fademode_box, TRUE, TRUE, 0);
	gtk_widget_show(options_fademode_box);

	options_fademode_stars = gtk_radio_button_new_with_label(NULL, "Stars");
	if (synx_cfg.fadeMode == Stars) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options_fademode_stars), TRUE);
	gtk_box_pack_start(GTK_BOX(options_fademode_box), options_fademode_stars, TRUE, TRUE, 0);
	gtk_widget_show(options_fademode_stars);
	options_fademode_group = gtk_radio_button_group(GTK_RADIO_BUTTON(options_fademode_stars));
	options_fademode_heat = gtk_radio_button_new_with_label(options_fademode_group, "Heat");
	if (synx_cfg.fadeMode == Flame) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options_fademode_heat), TRUE);
	gtk_box_pack_start(GTK_BOX(options_fademode_box), options_fademode_heat, TRUE, TRUE, 0);
	gtk_widget_show(options_fademode_heat);
	options_fademode_wave = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(options_fademode_heat)), "Wave");
	if (synx_cfg.fadeMode == Wave) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options_fademode_wave), TRUE);
	gtk_box_pack_start(GTK_BOX(options_fademode_box), options_fademode_wave, TRUE, TRUE, 0);
	gtk_widget_show(options_fademode_wave);

	gtk_signal_connect(GTK_OBJECT(options_fademode_stars), "toggled",
			(GtkSignalFunc)synx_fademode_toggle_cb, NULL);
	gtk_signal_connect(GTK_OBJECT(options_fademode_heat), "toggled",
			(GtkSignalFunc)synx_fademode_toggle_cb, NULL);
	gtk_signal_connect(GTK_OBJECT(options_fademode_wave), "toggled",
			(GtkSignalFunc)synx_fademode_toggle_cb, NULL);

	options_diamonds = gtk_check_button_new_with_label("Points are Diamonds");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options_diamonds), synx_cfg.pointsAreDiamonds);
	gtk_box_pack_start(GTK_BOX(options_vbox), options_diamonds, TRUE, TRUE, 0);
	gtk_widget_show(options_diamonds);
	gtk_signal_connect(GTK_OBJECT(options_diamonds), "toggled",
			(GtkSignalFunc)diamond_cb, NULL);

	options_twiddler_box = gtk_vbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(options_vbox), options_twiddler_box, TRUE, TRUE, 0);
	gtk_widget_show(options_twiddler_box);

	box = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(options_twiddler_box), box, TRUE, TRUE, 0);
	gtk_widget_show(box);
	label = gtk_label_new("Brightness");
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
	gtk_widget_show(label);
	options_brightness_adj = gtk_adjustment_new(synx_cfg.brightnessTwiddler*100, 0.0, 100.0, 0.1, 1.0, 1.0);
	gtk_signal_connect(GTK_OBJECT(options_brightness_adj), "value_changed", GTK_SIGNAL_FUNC(brightness_cb), NULL);
	options_brightness = gtk_hscale_new(GTK_ADJUSTMENT(options_brightness_adj));
	gtk_box_pack_start(GTK_BOX(box), options_brightness, TRUE, TRUE, 0);
	gtk_widget_set_usize(GTK_WIDGET(options_brightness), 350, 30);
	gtk_scale_set_draw_value(GTK_SCALE(options_brightness), FALSE);
	gtk_widget_show(options_brightness);

	box = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(options_twiddler_box), box, TRUE, TRUE, 0);
	gtk_widget_show(box);
	label = gtk_label_new("Star size");
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
	gtk_widget_show(label);
	options_starsize_adj = gtk_adjustment_new(synx_cfg.starSize*100, 0.0, 100.0, 0.1, 1.0, 1.0);
	gtk_signal_connect(GTK_OBJECT(options_starsize_adj), "value_changed", GTK_SIGNAL_FUNC(starsize_cb), NULL);
	options_starsize = gtk_hscale_new(GTK_ADJUSTMENT(options_starsize_adj));
	gtk_box_pack_start(GTK_BOX(box), options_starsize, TRUE, TRUE, 0);
	gtk_widget_set_usize(GTK_WIDGET(options_starsize), 350, 30);
	gtk_scale_set_draw_value(GTK_SCALE(options_starsize), FALSE);
	gtk_widget_show(options_starsize);


	/* Color stuff */
	options_fg_red_adj = gtk_adjustment_new(synx_cfg.fgRed*100, 0.0, 100.0, 0.1, 1.0, 1.0);
	gtk_signal_connect(GTK_OBJECT(options_fg_red_adj), "value_changed", GTK_SIGNAL_FUNC(color_changed_cb), NULL);
	options_fg_green_adj = gtk_adjustment_new(synx_cfg.fgGreen*100, 0.0, 100.0, 0.1, 1.0, 1.0);
	gtk_signal_connect(GTK_OBJECT(options_fg_green_adj), "value_changed", GTK_SIGNAL_FUNC(color_changed_cb), NULL);
	options_bg_red_adj = gtk_adjustment_new(synx_cfg.bgRed*100, 0.0, 100.0, 0.1, 1.0, 1.0);
	gtk_signal_connect(GTK_OBJECT(options_bg_red_adj), "value_changed", GTK_SIGNAL_FUNC(color_changed_cb), NULL);
	options_bg_green_adj = gtk_adjustment_new(synx_cfg.bgGreen*100, 0.0, 100.0, 0.1, 1.0, 1.0);
	gtk_signal_connect(GTK_OBJECT(options_bg_green_adj), "value_changed", GTK_SIGNAL_FUNC(color_changed_cb), NULL);

	/* FG box */
	box = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(options_vbox), box, TRUE, TRUE, 0);
	gtk_widget_show(box);

	/* Red FG */
	label = gtk_label_new("RedFG");
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
	gtk_widget_show(label);
	widget = gtk_hscale_new(GTK_ADJUSTMENT(options_fg_red_adj));
	gtk_widget_set_usize(GTK_WIDGET(widget), 175, 30);
	gtk_scale_set_draw_value(GTK_SCALE(widget), FALSE);
	gtk_box_pack_start(GTK_BOX(box), widget, TRUE, TRUE, 0);
	gtk_widget_show(widget);

	/* Green FG */
	widget = gtk_hscale_new(GTK_ADJUSTMENT(options_fg_green_adj));
	gtk_widget_set_usize(GTK_WIDGET(widget), 175, 30);
	gtk_scale_set_draw_value(GTK_SCALE(widget), FALSE);
	gtk_box_pack_start(GTK_BOX(box), widget, TRUE, TRUE, 0);
	gtk_widget_show(widget);
	label = gtk_label_new("GreenFG");
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
	gtk_widget_show(label);


	/* BG box */
	box = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(options_vbox), box, TRUE, TRUE, 0);
	gtk_widget_show(box);

	/* Red BG */
	label = gtk_label_new("RedBG");
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
	gtk_widget_show(label);
	widget = gtk_hscale_new(GTK_ADJUSTMENT(options_bg_red_adj));
	gtk_widget_set_usize(GTK_WIDGET(widget), 175, 30);
	gtk_scale_set_draw_value(GTK_SCALE(widget), FALSE);
	gtk_box_pack_start(GTK_BOX(box), widget, TRUE, TRUE, 0);
	gtk_widget_show(widget);

	/* Green BG */
	widget = gtk_hscale_new(GTK_ADJUSTMENT(options_bg_green_adj));
	gtk_widget_set_usize(GTK_WIDGET(widget), 175, 30);
	gtk_scale_set_draw_value(GTK_SCALE(widget), FALSE);
	gtk_box_pack_start(GTK_BOX(box), widget, TRUE, TRUE, 0);
	gtk_widget_show(widget);
	label = gtk_label_new("GreenBG");
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
	gtk_widget_show(label);


	/* Width/Height/Scale box */
	box = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(options_vbox), box, TRUE, TRUE, 0);
	gtk_widget_show(box);

	/* Width x Height */
	options_width_adj = gtk_adjustment_new(synx_cfg.req_w, 16, 1024, 1.0, 16.0, 1.0);
	gtk_signal_connect(GTK_OBJECT(options_width_adj), "value_changed", GTK_SIGNAL_FUNC(size_changed_cb), NULL);
	options_height_adj = gtk_adjustment_new(synx_cfg.req_h, 16, 768, 1.0, 16.0, 1.0);
	gtk_signal_connect(GTK_OBJECT(options_height_adj), "value_changed", GTK_SIGNAL_FUNC(size_changed_cb), NULL);

	/* Width */
	label = gtk_label_new("Width");
	gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
	widget = gtk_hscale_new(GTK_ADJUSTMENT(options_width_adj));
	gtk_box_pack_start(GTK_BOX(box), widget, TRUE, TRUE, 0);
	gtk_widget_show(widget);
	
	/* x :) */
	label = gtk_label_new("x");
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
	gtk_widget_show(label);

	/* Height */
	widget = gtk_hscale_new(GTK_ADJUSTMENT(options_height_adj));
	gtk_box_pack_start(GTK_BOX(box), widget, TRUE, TRUE, 0);
	gtk_widget_show(widget);
	label = gtk_label_new("Height");
	gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
	

	/* Fullscreen stuff */
	if (xmms_fullscreen_available(GDK_DISPLAY())) {
		box = gtk_hbox_new(FALSE, 5);
		gtk_box_pack_start(GTK_BOX(options_vbox), box, TRUE, TRUE, 0);
		gtk_widget_show(box);

		/* Auto fullscreen */
		label = gtk_check_button_new_with_label("Fullscreen on play");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(label), synx_cfg.auto_fullscreen);
		gtk_signal_connect(GTK_OBJECT(label), "toggled",
			GTK_SIGNAL_FUNC(synx_fullscreen_cb), NULL);
		gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
		gtk_widget_show(label);

		/* Scale when fullscreen */
		label = gtk_check_button_new_with_label("Fit screen in fullscreen");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(label), synx_cfg.scale);
		gtk_signal_connect(GTK_OBJECT(label), "toggled",
			GTK_SIGNAL_FUNC(synx_scale_cb), NULL);
		gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 0);
		gtk_widget_show(label);
	}

	/* Finish up */
	gtk_container_add(GTK_CONTAINER(options_frame), options_vbox);
	gtk_widget_show(options_vbox);

	gtk_box_pack_start(GTK_BOX(vbox), options_frame, TRUE, TRUE, 0);
	gtk_widget_show(options_frame);

	bbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

	ok = gtk_button_new_with_label("Ok");
	gtk_signal_connect(GTK_OBJECT(ok), "clicked",
			   GTK_SIGNAL_FUNC(configure_ok), NULL);
	GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
	gtk_widget_show(ok);


	cancel = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(cancel), "clicked",
			   GTK_SIGNAL_FUNC(configure_cancel),
			   (gpointer)NULL);
	GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
	gtk_widget_show(cancel);
	gtk_widget_show(bbox);

	gtk_container_add(GTK_CONTAINER(configure_win), vbox);
	gtk_widget_show(vbox);
	gtk_widget_show(configure_win);
	gtk_widget_grab_default(ok);
}
