/*
 *	$COPYRIGHT$
 *
 *	$Id: xmpi_aschema.cc,v 1.3 2000/10/29 19:32:01 bbarrett Exp $
 *
 *	Function:	- dialog window for browsing application schemata
 */

#include <Xm/Xm.h>
#include <Xm/FileSB.h>

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "xmpi.h"
#include "xmpi_aschema.h"
#include "xmpi_run.h"
#include "xmpi_ctl.h"
#include "xmpi_misc.h"


/*
 * local functions
 */
static void runapp(Widget, caddr_t, 
		   XmFileSelectionBoxCallbackStruct*);

/*
 * local variables
 */
static Widget appdialog = 0;	       /* file selection dialog */

/*
 *	xmpi_aschema_dialog
 *
 *	Function:	- pops up application selection dialog
 *	Accepts:	- parent widget
 */
void
xmpi_aschema_dialog(Widget parent)
{
  Arg args[2];

  XmString oklabel;

  XmString title;

  Widget help_btn;

  if (appdialog == 0) {
    title = XmStringCreateSimple((char*) "XMPI Application Browser");
    oklabel = XmStringCreateSimple((char*) "Run");

    XtSetArg(args[0], XmNdialogTitle, title);
    XtSetArg(args[1], XmNokLabelString, oklabel);

    appdialog = XmCreateFileSelectionDialog(parent,
					    (char*) "app_browser", args, 2);

    XtAddCallback(appdialog, XmNokCallback, 
		  (XtCallbackProc) runapp, NULL);
    XtAddCallback(appdialog, XmNcancelCallback,
		  (XtCallbackProc) XtUnmanageChild, NULL);

    help_btn = XmFileSelectionBoxGetChild(appdialog,
					  XmDIALOG_HELP_BUTTON);
    XtUnmanageChild(help_btn);

    XmStringFree(title);
    XmStringFree(oklabel);
  } else {
    XtMapWidget(xmpi_wmshell(appdialog));
    XmFileSelectionDoSearch(appdialog, 0);
  }

  XtManageChild(appdialog);
  XtPopup(XtParent(appdialog), XtGrabNone);
}

/*
 *	runapp
 *
 *	Function:	- run selected application (OK callback)
 *	Accepts:	- callback data
 */
static void
runapp(Widget w, caddr_t, 
       XmFileSelectionBoxCallbackStruct *cbs)
{
  char *appname;		       /* app. file name */

  int r;

  if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &appname))
    return;

  XtUnmapWidget(xmpi_wmshell(w));

  r = xmpi_run(appname, xmpi_wmshell(w));

  if (r == 0) {
    xmpi_ctl_setapp(appname);
  }
  XtFree(appname);
}

/*
 *	xmpi_aschema_busy
 *
 *	Function:	- set the busy cursor in the schema browsing window
 */
void
xmpi_aschema_busy()
{
  if (appdialog)
    xmpi_busy_widget(appdialog);
}

/*
 *	xmpi_aschema_unbusy
 *
 *	Function:	- reset the busy cursor in the schema browsing window
 */
void
xmpi_aschema_unbusy()
{
  if (appdialog)
    xmpi_unbusy_widget(appdialog);
}
