/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: sfh.h,v 1.3 1999/11/08 07:15:41 arodrig6 Exp $
 *
 *	Function:	- constants, templates and prototypes
 */

#ifndef _SFH_H
#define _SFH_H

#include <xmpi_config.h>
#include <sys/types.h>
#include <netinet/in.h>

#ifdef __cplusplus
extern "C" {
#endif

extern void	sfh_itoa __ARGS((int, char *));

extern int	sfh_argv_add __ARGS((int *, char ***, char *));
extern int	sfh_argv_count __ARGS((char **));
extern void	sfh_argv_free __ARGS((char **));
extern char	**sfh_argv_break __ARGS((const char *, int));
extern char	**sfh_argv_dup __ARGS((char **));
extern char	*sfh_argv_glue __ARGS((char **, int, unsigned int));
extern unsigned int sfh_argv_len __ARGS((char **));
extern char 	**sfh_argv_break_quoted __ARGS((char *, int, char[]));
extern char	*sfh_argv_quote __ARGS((const char *, char[]));

extern char	*sfh_path_find __ARGS((char *, char **, int));
extern char	*sfh_path_env_find __ARGS((char *, int));
extern char	*sfh_path_findv __ARGS((char *, char **, int, char **));
extern char	*sfh_path_env_findv __ARGS((char *, int, char **, char *));

extern int	sfh_sock_open_srv_inet_stm __ARGS((int *));
extern int	sfh_sock_open_clt_inet_stm __ARGS((unsigned char *, int));
extern int	sfh_sock_open_srv_unix_stm __ARGS((char *));
extern int	sfh_sock_open_clt_unix_stm __ARGS((char *));
extern int	sfh_sock_accept_tmout __ARGS((int, int));
extern int	sfh_sock_open_srv_inet_dgm __ARGS((int *));
extern int	sfh_sock_open_clt_inet_dgm __ARGS((void));
extern void	sfh_sock_fill_inet_addr __ARGS((unsigned char *, int,
						struct sockaddr_in *));
extern int	sfh_send_fd __ARGS((int, int));
extern int	sfh_recv_fd __ARGS((int));

#ifdef __cplusplus
extern "C" {
#endif

#endif	/* _SFH_H */
