/* xpenguins_applet.h - gnome panel applet implementation of xpenguins
 * Copyright (C) 1999, 2000  Robin Hogan
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Structure that contains all data worth remembering */
typedef struct {
  /* Application widget, and its subwidgets */
  GtkWidget *applet;
  GtkWidget *button, *playpause, *stop;
  GtkWidget *button_pixmap, *playpause_pixmap, *stop_pixmap;
  GtkWidget *hbox, *vbox;
  /* Property box widgets */
  GtkWidget *prop_window;
  GtkAdjustment *number_adj, *speed_adj;
  GtkWidget *ignorepopups_check;
  GtkWidget *noblood_check;
  GtkWidget *overridetheme_check;
  GtkWidget *table;
  GtkWidget *preview_pixmap, *preview, *info;
  /* Other widgets */
  GtkWidget *error_dialog;
  /* Theme information */
  gchar **theme_list;
  gchar **theme_info;
  gchar *theme_name;
  gchar *next_theme_name;
  gint nthemes;
  XPenguinsTheme theme;
  /* Properties */
  gint timeout, number, speed;
  gboolean active, ignorepopups, paused;
  gboolean noblood, overridetheme, loaded;
  gboolean send_event;
} XPenguinData;


/* PROTOTYPES */

/* Load theme and handle errors */
int load_theme(XPenguinData *xp);

/* Bring up the property box */
void property_show(AppletWidget *applet, gpointer data);

/* Timeout callback to update toons */
int service_xpenguins(gpointer data);

