/*

    xpuyopuyo - pplayer.c     Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Player code
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <xpuyopuyo.h>
#include <psnprintf.h>
#include <pplayer.h>
#include <pwindow.h>
#include <ppiece.h>


void p_player_resize_field(pplayer *p, int width, int height, int numcolors) {

   if(p->field) p_field_free(&p->field);
   p->field = p_field_new(width, height, p->number);

   p_player_calc_next(p, numcolors);
   p_piece_new(p->field, &p->next);
   p_player_calc_next(p, numcolors);
   
}


pplayer *p_player_new(int num, int nc, int width, int height, int numcolors) {

   pplayer *p;
   int i;
   
   if(!(p = (pplayer *)malloc(sizeof(pplayer)))) {
      perror("Cannot allocate pplayer");
      return(NULL);
   }
   
   p->number = num;
   p->field = NULL;
   p_player_resize_field(p, width, height, numcolors);
   
   p->scorerocks = 0;
   p->score = 0;
   p->rocks = 0;
   p->accum = 0;
   p->wins = 0;
   for(i = 0; i < P_PLAYER_NUM_CLUMPS; i++) {
      p->num_clumps[i] = 0;
   }
   
   p->aiactive = 0;
   p->network = 0;
   
   p_player_set_name(p, NULL);
   
   return(p);

}


void p_player_free(pplayer **p) {

   if(!p || !*p) return;
   p_field_free(&(*p)->field);
   free(*p);
   *p = NULL;

}


void p_player_calc_next(pplayer *p, int numcolors) {

   int tile;
   int i;

   for(i = 0; i < 2; i++) {
      tile = rand() % numcolors;
      p->next.block[i] = tile;
   }

}


void p_player_set_name(pplayer *p, const char *name) {

   if(name == NULL) {
      p_snprintf(p->name, P_PLAYER_NAME_SIZE, "Human Player %d", p->number + 1);
   } else {
      p_strncpy(p->name, name, P_PLAYER_NAME_SIZE);
   }

}
