.\" @(#)xcubes.man
.\"
.\" Copyright 1994 - 2010  David A. Bagley
.\"
.\" All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "useful",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH XCUBES 6 "29 Jun 2010" "V7.6.3"
.SH NAME
xcubes \- Cubes X widget
.SH SYNOPSIS
.B /usr/games/xcubes
[\-geometry [{width}][x{height}][{+\-}{xoff}[{+\-}{yoff}]]]
[\-display [{host}]:[{vs}]] [\-[no]mono] [\-[no]{reverse|rv}]
[\-{foreground|fg} {color}] [\-{background|bg} {color}]
[\-block {color}] [\-text {color}] [\-[no]install]
[\-picture {filename}] [\-delay msecs] [\-[no]sound]
[\-bumpSound {filename}] [\-dripSound {filename}]
[\-{font|fn} {fontname}] [\-size{x|y|z} {int}] [\-base {int}]
[\-userName {string}] [\-scoreFile {filename}] [\-scores]
[\-version]
.SH DESCRIPTION
.LP
A 3D sliding block puzzle.  The cubes represented are flattened out
on the plane.  If the Blocks Z slider is greater than 1, then each group
of boxes is a layer of the puzzle.  If the Blocks Z slider = 1, then this
is a simple 15 tile puzzle.  The 15 puzzle was originally made around
1880 by Noyes Chapman (the 14\-15 puzzle of Sam Loyd was made soon after).
Similar 3D puzzles include BloxBox; Qrazy Qube (2x2x2) by P. Hein of
Denmark and Varikon Box 'L (3x3x3) (Hungary) and Mad Marbles (3x3x3) by
Toys & Games International USA.
.SH FEATURES
Click "\fBmouse\-left\fP" button to move a block.  Clicks on a space, or
clicks on blocks that are not in line with a space, will not move the
blocks.  Notice, one can move more than one block at a time by clicking on
the block farthest from the space but still in line with the space.  Since
you only have a 2\-D screen, the next level down is either the box to the
right of the current box or the bottom of the current box.
.LP
Click "\fBmouse\-right\fP" button, or press "\fBC\fP" or "\fBc\fP" keys, to
clear the puzzle.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to save (write) a puzzle.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBR\fP" or "\fBr\fP" keys to redo a move.
.LP
Press "\fBZ\fP" or "\fBz\fP" keys to randomize the puzzle.  New records
can only be set from a cleared state.
.LP
Press "\fBS\fP" or "\fBs\fP" keys to start the auto\-solver.  Only works on
lxmx1 where l > 3 and m > 3.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to move a block in.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to move a block out.
.LP
Press "\fB>\fP" or "\fB.\fP" keys to speed up the movement of blocks.
.LP
Press "\fB<\fP" or "\fB,\fP" keys to slow down the movement of blocks.
.LP
Press "\fB@\fP" key to toggle the sound.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL\-C\fP" keys to kill program.
.LP
Use the key pad or arrow keys to move without the mouse.
.br
Key pad is defined for Cubes as:
.br
  /     Out
.sp
  8     Up
.br
  ^
.br
4<5>6   Left, In, Right
.br
  v
.br
  2     Down
.LP
The control key allows you to change the complexity of xcubes.  Hold
down control key and use the keypad or arrow keys to reduce or enlarge
puzzle complexity.
.LP
The title is in the following format (non\-motif version):
.RS
xcubes: <Number of columns>x<Number of rows>x<Number of stacks> @
(<Number of moves>/{<Record number of moves>
<user name>|"NEVER noaccess"}) \- <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the cubes window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to display the cubes window on a color screen as
if it were monochrome (resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the cubes window in reverse video (resource
name "\fIreverseVideo\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the cubes window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the cubes window (resource name
"\fIbackground\fP").
.TP 8
.B \-block \fIcolor\fP
This option specifies the block color of the blocks in the cubes window
(resource name "\fIblockColor\fP").
.TP 8
.B \-text \fIcolor\fP
This option specifies the text color of the blocks in the cubes window
(resource name "\fItextColor\fP").
.TP 8
.B \-[no]install
This option specifies if the colormap should be installed or not
(resource name "\fIinstall\fP").
.TP 8
.B \-picture \fIfilename\fP
This option specifies the file for the picture (resource name
"\fIpicture\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move a block
or a group of blocks one space (1\-50) (resource name "\fIdelay\fP").
.TP 8
.B \-[no]sound
This option specifies if a sliding block should make a sound or not
(resource name "\fIsound\fP").
.TP 8
.B \-bumpSound \fIfilename\fP
This option specifies the file for the bump sound for the sliding of
the tiles (resource name "\fIbumpSound\fP").
.TP 8
.B \-dripSound \fIfilename\fP
This option specifies the file for the drip sound for the dropping or
raising of the tiles (resource name "\fIdripSound\fP").
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-size{x|y|z} <\fIint\fP>
This option allows you to change the number of cubes in a row, column, or
stack (resource name "\fIsizeX\fP", "\fIsizeY\fP", "\fIsizeZ\fP").
.TP 8
.B \-base \fIint\fP
This option specifies the base used in cubes (default is base 10)
(resource name "\fIbase\fP").
.TP 8
.B \-userName \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.TP 8
.B \-scoreFile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-scores
This option lists all the recorded scores and then exits.
.TP 8
.B \-version
This option tells you what version of xcubes you have.
.SH RECORDS
You must randomize the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get or an
auto\-solve.
.SH SAVE FORMAT
Here is the format for the xcubes configuration, starting position, and
the movement of its pieces.
.sp
.RS
sizeX: 1\-8 <number of columns of blocks>
.br
sizeY: 1\-8 <number of rows of blocks>
.br
sizeZ: 1\-8 <number of blocks in a stack>
.br
moves: 0\-MAXINT <total number of moves>
.sp
startingPosition: <array of block positions where 0 is the empty space>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <direction>
.RE
Direction is represented as 0 up, 1 right, 2 down, 3 left, 4 in, and 5
out.
.SH REFERENCES
L. E. Horden, Sliding Piece Puzzles (Recreations in Mathematics Series),
Oxford University Press 1986, pp 1, 157\-159.
.sp
Jerry Slocum & Jack Botermans, Puzzles Old & New (How to Make and Solve
Them), University of Washington Press, Seattle, 1987, pp 126, 127.
.SH SEE ALSO
.LP
X(1), xtriangles(6), xhexagons(6), xmlink(6), xbarrel(6), xpanex(6),
xmball(6), xpyraminx(6), xoct(6), xrubik(6), xskewb(6), xdino(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1994\-2010, David A. Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David A. Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIhttp://www.tux.org/~bagleyd/puzzles.html\fP
.br
\fIftp://ibiblio.org/pub/Linux/games/strategy\fP
