/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: xracer-game.h,v 1.7 2000/03/19 23:48:47 rich Exp $
 */

#ifndef __xracer_game_h__
#define __xracer_game_h__

#include "config.h"

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#include "xracer-joystick.h"

struct xrGameModeArgs
{
  int mode;
  int nr_laps;
};

struct xrGameControls
{
  /* Joystick status. This is only valid if joystick_flag == true. */
  int joystick_flag;
  struct xrJoystickStatus joystick_status;

  /* State of the keyboard keys. */
  int keyboard_accelerate;
  int keyboard_brake;
  int keyboard_left;
  int keyboard_right;
  int keyboard_up;
  int keyboard_down;
  int keyboard_fire;

  /* State of the mouse. */
  int mouse_enabled;
  int mouse_inverted;
  float mouse_sensitivity;
  int mouse_accelerate;
  int mouse_brake;
  int mouse_x;			/* In screen coordinates. */
  int mouse_y;
};

struct xrGameKeyboardEvent
{
  void (*down) (void);		/* Key down. */
  void (*up) (void);		/* Key up. */
};

/* Standard game-mode keyboard events. */
extern struct xrGameKeyboardEvent xrGameKeyboardEventInvertMouse;
extern struct xrGameKeyboardEvent xrGameKeyboardEventToggleMouse;
extern struct xrGameKeyboardEvent xrGameKeyboardEventMouseSensitivityUp;
extern struct xrGameKeyboardEvent xrGameKeyboardEventMouseSensitivityDown;
extern struct xrGameKeyboardEvent xrGameKeyboardEventFire;
extern struct xrGameKeyboardEvent xrGameKeyboardEventLeft;
extern struct xrGameKeyboardEvent xrGameKeyboardEventRight;
extern struct xrGameKeyboardEvent xrGameKeyboardEventUp;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDown;
extern struct xrGameKeyboardEvent xrGameKeyboardEventAccelerate;
extern struct xrGameKeyboardEvent xrGameKeyboardEventBrake;

/* These game-mode keyboard events are used for debugging. */
extern struct xrGameKeyboardEvent xrGameKeyboardEventToggleDebug;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDebugSnapshotSettings;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDebugGravityUp;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDebugGravityDown;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDebugSpringDampingUp;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDebugSpringDampingDown;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDebugMomentumDampingUp;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDebugMomentumDampingDown;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDebugLevitateDistUp;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDebugLevitateDistDown;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDebugLevitateDampingUp;
extern struct xrGameKeyboardEvent xrGameKeyboardEventDebugLevitateDampingDown;

/* Table mapping keys to keyboard events. */
extern struct xrGameKeyboardEvent *xrGameKeyboardTable[UCHAR_MAX];
extern struct xrGameKeyboardEvent *xrGameSpecialTable[UCHAR_MAX];

extern void xrGameInit (void);

extern struct xrMode xrGameMode;

#endif /* __xracer_game_h__ */
