// file      : xsde/cxx/parser/elements.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef CXX_PARSER_ELEMENTS_HXX
#define CXX_PARSER_ELEMENTS_HXX

#include <sstream>

#include <cxx/elements.hxx>

#include <cxx/parser/cli.hxx>

namespace CXX
{
  namespace Parser
  {
    struct Content
    {
      enum Value
      {
        simple,
        complex,
        mixed
      };
    };

    //
    //
    class Context: public CXX::Context
    {
    public:
      Context (std::wostream&,
               SemanticGraph::Schema&,
               CLI::Options const&);

    protected:
      Context (Context& c)
          : CXX::Context (c),
            options (c.options),
            xml_parser (c.xml_parser),
            simple_base (c.simple_base),
            complex_base (c.complex_base),
            list_base (c.list_base),
            validation (c.validation),
            exceptions (c.exceptions)
      {
      }

      Context (Context& c, std::wostream& o)
          : CXX::Context (c, o),
            options (c.options),
            xml_parser (c.xml_parser),
            simple_base (c.simple_base),
            complex_base (c.complex_base),
            list_base (c.list_base),
            validation (c.validation),
            exceptions (c.exceptions)
      {
      }

    public:
      Boolean
      restriction_p (SemanticGraph::Complex& c) const
      {
        if (c.inherits_p () &&
            c.inherits ().is_a<SemanticGraph::Restricts> ())
        {
          // Restriction of anyType is a special case.
          //
          return !c.inherits ().base ().is_a<SemanticGraph::AnyType> ();
        }

        return false;
      }

    public:
      static Content::Value
      content (SemanticGraph::Complex&);

    public:
      static String const&
      ret_type (SemanticGraph::Type&);

      static String const&
      arg_type (SemanticGraph::Type&);

      static String const&
      post_name (SemanticGraph::Type&);

    public:
      static String const&
      eparser (SemanticGraph::Member&);

      static String const&
      emember (SemanticGraph::Member&);

    public:
      static String const&
      eimpl (SemanticGraph::Type&);

    public:
      CLI::Options const& options;
      String& xml_parser;
      String& simple_base;
      String& complex_base;
      String& list_base;
      Boolean& validation;
      Boolean& exceptions;

    private:
      CLI::Options const options_;
      String xml_parser_;
      String simple_base_;
      String complex_base_;
      String list_base_;
      Boolean validation_;
      Boolean exceptions_;
    };

    //
    //
    struct RequiredAttributeTest: Traversal::Attribute
    {
      RequiredAttributeTest (Boolean& result)
          : result_ (result)
      {
      }

      virtual Void
      traverse (Type& a)
      {
        if (!result_ && !a.optional ())
          result_ = true;
      }

    private:
      Boolean& result_;
    };


    //
    //
    struct ParticleParamDecl: Traversal::Element,
                              protected virtual Context
    {
      ParticleParamDecl (Context& c, Boolean& first, Boolean name_arg)
          : Context (c), first_ (first), name_arg_ (name_arg)
      {
      }

      virtual Void
      traverse (SemanticGraph::Element& e)
      {
        if (!first_)
          os << "," << endl;
        else
          first_ = false;

        os << fq_name (e.type ()) << "&";

        if (name_arg_)
          os << " " << ename (e);
        else
          os << " /* " << e.name () << " */";
      }

    private:
      Boolean& first_;
      Boolean name_arg_;
    };

    struct AttributeParamDecl: Traversal::Attribute,
                               protected virtual Context
    {
      AttributeParamDecl (Context& c, Boolean& first, Boolean name_arg)
          : Context (c), first_ (first), name_arg_ (name_arg)
      {
      }

      virtual Void
      traverse (Type& a)
      {
        if (!first_)
          os << "," << endl;
        else
          first_ = false;

        os << fq_name (a.type ()) << "&";

        if (name_arg_)
          os << " " << ename (a);
        else
          os << " /* " << a.name () << " */";
      }

    private:
      Boolean& first_;
      Boolean name_arg_;
    };

    struct ParserParamDecl : Traversal::Complex,
                             Traversal::List,
                             protected virtual Context
    {
      ParserParamDecl (Context& c, Boolean name_arg)
          : Context (c),
            particle_ (c, first_, name_arg),
            attribute_ (c, first_, name_arg),
            first_ (true),
            name_arg_ (name_arg)
      {
        inherits_ >> *this;

        contains_compositor_ >> compositor_ >> contains_particle_;
        contains_particle_ >> particle_;
        contains_particle_ >> compositor_;

        names_ >> attribute_;
      }

      virtual Void
      traverse (SemanticGraph::Complex& c)
      {
        inherits (c, inherits_);

        if (!restriction_p (c))
        {
          names (c, names_);
          contains_compositor (c, contains_compositor_);
        }
      }

      virtual Void
      traverse (SemanticGraph::List& l)
      {
        if (!first_)
          os << "," << endl;
        else
          first_ = false;

        os << fq_name (l.argumented ().type ()) << "&";

        if (name_arg_)
          os << " " << ename (l) << "_item";
        else
          os << " /* " << l.name () << " item */";
      }

    private:
      Traversal::Inherits inherits_;

      Traversal::Compositor compositor_;
      ParticleParamDecl particle_;
      Traversal::ContainsCompositor contains_compositor_;
      Traversal::ContainsParticle contains_particle_;

      AttributeParamDecl attribute_;
      Traversal::Names names_;

      Boolean first_;
      Boolean name_arg_;
    };
  }
}

#endif  // CXX_PARSER_ELEMENTS_HXX
