/* --------------------------------------------------------------------------
 * ``Open Sound System (OSS)'' specific audio driver interface.
 * --------------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef AUDIODRIVER_H
#define AUDIODRIVER_H

#include "AudioBase.h"

class AudioDriver : public AudioBase
{

 public:  // --------------------------------------------------------- public

	AudioDriver();
	~AudioDriver();
  
	bool open(const AudioConfig&);
	
	// Free and close opened audio device and reset any variables that
	// reflect the current state of the driver.
	void close();
	
	void play(void* buffer, unsigned long int bufferSize);

	bool reset();
	
 private:  // ------------------------------------------------------- private

	static const char AUDIODEVICE[];
	int audioHd;
	
	void outOfOrder();

	// Check device availability and write permissions.
	bool isThere();

	bool swapEndian;
};

#endif  /* AUDIODRIVER_H */

