/*******************************************************************
 * The core generic OS event loop.
 * File: generic_core.c
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: generic_core.c,v 1.3 2005/08/09 01:39:15 chessing Exp $
 * $Date: 2005/08/09 01:39:15 $
 * $Log: generic_core.c,v $
 * Revision 1.3  2005/08/09 01:39:15  chessing
 * Cleaned out old commit notes from the released version.  Added a few small features including the ability to disable the friendly warnings that are spit out.  (Such as the warning that is displayed when keys aren't rotated after 10 minutes.)  We should also be able to start when the interface is down.  Last, but not least, we can handle empty network configs.  (This may be useful for situations where there isn't a good reason to have a default network defined.)
 *
 *
 *******************************************************************/

#ifdef GENERIC_FRAMER

#include <dnet.h>
#include <pcap.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "profile.h"
#include "config.h"
#include "eap.h"
#include "statemachine.h"
#include "xsup_debug.h"
#include "xsup_err.h"
#include "eapol.h"
#include "cardif/cardif.h"
#include "cardif/core.h"

/*****************************************************************
 *
 * Do any setup that is needed for our event loop.  This is called only
 * once!  (And not once per interface.)  If you need to initalize something
 * per interface, is should either be included in cardif_init(), or using
 * some checks in event_core()!
 *
 *****************************************************************/
void event_core_setup()
{
  debug_printf(DEBUG_INT, "Called event_core_setup()!\n");
}

/*****************************************************************
 *
 * Called every time the clock ticks.  (Once per second.)
 *
 *****************************************************************/
void event_core_clock_tick(struct interface_data *intdata)
{
}

/*****************************************************************
 *
 * Do any event processing that needs to happen.  This *MUST* include
 * executing the statemachine for each interface we know of, and sending
 * and receiving of frames.
 *
 *****************************************************************/
void event_core(struct interface_data *cur)
{
  int framewaiting = 0;

  if (cur->userdata == NULL)
    {
      debug_printf(DEBUG_NORMAL, "Userdata is NULL!  We will probably have problems!\n");
    }
  
  eapol_execute(cur);
  
  // If we have a frame available on any interface, we won't
  // sleep.  Instead we will keep looping through to keep things
  // moving as fast as possible.
  if (frameavail(cur) == TRUE) framewaiting = 1;

  if (framewaiting == 0)
    {
      usleep(500000);
    }
  framewaiting = 0;
}

/******************************************************************
 *
 * Clean up anything that we initialized in event_core_setup().
 *
 ******************************************************************/
void event_core_cleanup()
{
  debug_printf(DEBUG_INT, "Called event_core_cleanup()!\n");
}

#endif
