/*  SubordinateStation  Implementation for offset station.
    Last modified 1998-12-13

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class SubordinateStation: public Station {
public:
  SubordinateStation (ReferenceStation *rs, SubordinateStationRef *ssr);
  ~SubordinateStation();
  int is_reference_station();
  HairyOffsets *residualOffsets;

  PredictionValue minLevel() const;
  PredictionValue maxLevel() const;

  PredictionValue predictApproximate (Timestamp t);

  // tm (in-out) is "uncorrected" or "internal" timestamp
  // t_out is "corrected" timestamp (with offsets applied)
  // For reference station or simple offsets, they are identical.
  void predictExactTideEvent (Timestamp &tm, Direction d,
    Timestamp &t_out, EventType &etype_out, Dstr &etype_desc,
    PredictionValue &pv_out);

protected:
  Offsets *origOffsets;
  void reduce_offsets();

  // Bracket used by predictApproximate
  Timestamp bracketleft, bracketright;
  PredictionValue usemax, usemin;

  int isReasonable (Timestamp tm, PredictionValue pv, int ishigh);
};
