//---------------------------------------------------------------------------
#ifndef __HRAY_HDRIMAGE__
#define __HRAY_HDRIMAGE__

#include "color.h"
#include <stdio.h>      //file ops

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

__BEGIN_YAFRAY
#define MINELEN 8
#define MAXELEN 0x7fff
#define MINRUN	4	// minimum run length
#define RED 0
#define GRN 1
#define BLU 2
#define EXP 3
#define COLXS 128
typedef unsigned char RGBE[4];
typedef CFLOAT fCOLOR[3];
// copy source -> dest
#define copy_rgbe(c1, c2) (c2[RED]=c1[RED],c2[GRN]=c1[GRN],c2[BLU]=c1[BLU],c2[EXP]=c1[EXP])
#define copy_fcol(f1, f2) (f2[RED]=f1[RED],f2[GRN]=f1[GRN],f2[BLU]=f1[BLU])

enum HDRFORMAT {HDR_FLOAT, HDR_RGBE};

class HDRimage_t
{
public:
  // ctor
  HDRimage_t()
  {
    fRGB = NULL;
    rgbe_scan = NULL;
    RGBE_img = NULL;
    EXPadjust = 0;
  }
  // dtor
  ~HDRimage_t() { freeBuffers(); }
  // mtds
  bool LoadHDR(const char* filename, HDRFORMAT hf);
  bool SaveHDR(const char* filename);
  void setExposureAdjust(int ex) { EXPadjust = ex; }
  color_t BilerpSample(GFLOAT u, GFLOAT v);
protected:
  FILE *file;
  fCOLOR* fRGB;  //float rgb img.
  RGBE* rgbe_scan;  //scanline buffer for writing
  RGBE* RGBE_img;  //rgbe image
  int xmax,ymax;
  int EXPadjust;
  void freeBuffers();
  bool CheckHDR();
  bool radiance2fp();
  bool radiance2rgbe();
  bool fp2radiance();
  bool freadcolrs(RGBE *scan);
  bool oldreadcolrs(RGBE *scan);
  int fwritecolrs(fCOLOR *scan);
  void RGBE2FLOAT(RGBE rgbe, fCOLOR fcol);
  void FLOAT2RGBE(fCOLOR fcol, RGBE rgbe);
  void ExposureAdjust_rgbe2float(RGBE rgbe, fCOLOR acol);
  void ExposureAdjust_float(fCOLOR fcol, fCOLOR acol);
};

__END_YAFRAY
#endif // __HRAY_HDRIMAGE__
