// $Id: searchdialog.cc 2719 2009-08-20 01:30:25Z rafi $
//
// Copyright (C) 2008, 2009  Rafael Ostertag
//
// This file is part of YAPET.
//
// YAPET is free software: you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version.
//
// YAPET is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//
// You should have received a copy of the GNU General Public License along with
// YAPET.  If not, see <http://www.gnu.org/licenses/>.
//

#include "../intl.h"
#include <colors.h>
#include "searchdialog.h"

void
SearchDialog::createWindow() throw (YAPET::UI::UIException) {
    if (window != NULL)
        throw YAPET::UI::UIException (_ ("May you consider deleting the window before reallocating") );

    window = newwin (getHeight(), getWidth(), getStartY(), getStartX() );

    if (window == NULL)
        throw YAPET::UI::UIException (_ ("Error creating search dialog") );

    searchtermw = new YAPET::UI::InputWidget (getStartX() + 1,
            getStartY() + 2,
            getWidth() - 2);
    okbutton = new YAPET::UI::Button (_ ("OK"),
                                      getStartX() + 1,
                                      getStartY() + getHeight() - 2);
    cancelbutton = new YAPET::UI::Button (_ ("Cancel"),
                                          getStartX() + okbutton->getLength() + 2,
                                          getStartY() + getHeight() - 2);
}

SearchDialog::SearchDialog() throw (YAPET::UI::UIException) : window (NULL),
        searchtermw (NULL),
        okbutton (NULL),
        cancelbutton (NULL),
        searchterm (""),
        canceled (true) {
    createWindow();
}

SearchDialog::~SearchDialog() {
    delete searchtermw;
    delete okbutton;
    delete cancelbutton;
    delwin (window);
}

void
SearchDialog::run() throw (YAPET::UI::UIException) {
    refresh();

    while (true) {
        int ch = 0;
#ifdef HAVE_WRESIZE

        while ( (ch = searchtermw->focus() ) == KEY_RESIZE)
            YAPET::UI::BaseWindow::resizeAll();

#else // HAVE_WRESIZE
        ch = searchtermw->focus();
#endif // HAVE_WRESIZE

        if (ch == KEY_ESC) {
            canceled = true;
            return;
        }

#ifdef HAVE_WRESIZE

        while ( (ch = okbutton->focus() ) == KEY_RESIZE)
            YAPET::UI::BaseWindow::resizeAll();

#else // HAVE_WRESIZE
        ch = okbutton->focus();
#endif // HAVE_WRESIZE

        switch (ch) {
            case KEY_ESC:
                canceled = true;
                return;
            case '\n':
                canceled = false;
                return;
        }

#ifdef HAVE_WRESIZE

        while ( (ch = cancelbutton->focus() ) == KEY_RESIZE)
            YAPET::UI::BaseWindow::resizeAll();

#else // HAVE_WRESIZE
        ch = cancelbutton->focus();
#endif // HAVE_WRESIZE

        if (ch == '\n' || ch == KEY_ESC) {
            canceled = true;
            return;
        }
    }
}

void
SearchDialog::resize() throw (YAPET::UI::UIException) {
    int retval = delwin (window);

    if (retval == ERR)
        throw YAPET::UI::UIException (_ ("Error deleting search dialog window") );

    delete searchtermw;
    delete okbutton;
    delete cancelbutton;
    window = NULL;
    searchtermw = NULL;
    okbutton = NULL;
    cancelbutton = NULL;
    createWindow();
}

void
SearchDialog::refresh() throw (YAPET::UI::UIException) {
    YAPET::UI::Colors::setcolor (window, YAPET::UI::MESSAGEBOX);
    int retval = werase (window);

    if (retval == ERR)
        throw YAPET::UI::UIException (_ ("Error clearing search dialog") );

    retval = box (window, 0, 0);

    if (retval == ERR)
        throw YAPET::UI::UIException (_ ("Error adding box") );

    retval = mymvwaddstr (window, 0, 2, _ ("S E A R C H") );

    if (retval == ERR)
        throw YAPET::UI::UIException (_ ("Error setting title") );

    // The label
#ifdef HAVE_STRCASESTR
    retval = mymvwaddstr (window, 1, 1, _ ("Please enter the search term") );
#else
# ifdef HAVE_TOLOWER
    retval = mymvwaddstr (window, 1, 1, _ ("Please enter the search term") );
# else
    retval = mymvwaddstr (window, 1, 1, _ ("Please enter the search term (case-sensitive)") );
# endif // HAVE_TOLOWER
#endif

    if (retval == ERR)
        throw YAPET::UI::UIException (_ ("Error setting label") );

    retval = wrefresh (window);

    if (retval == ERR)
        throw YAPET::UI::UIException (_ ("Error refreshing the search dialog") );

    searchtermw->refresh();
    okbutton->refresh();
    cancelbutton->refresh();
}
