/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_DISPATCHER_H)
#define __INC_DISPATCHER_H

#include <sys/types.h>
#include <sys/time.h>

#include <list>
#include <map>

#include <sigc++/object.h>

namespace SigC
{

using namespace std;

class Dispatcher : public Object
{
  public:
    enum Event { Timer, Read, Write, Except, All, Remove, Moved };

    class Handler
    {
      public:
        typedef Dispatcher::Event Event;
        virtual void callback(Dispatcher *, Event) = 0;
        virtual ~Handler();
    };
    
    virtual ~Dispatcher();

    virtual void add_input_handler(Handler *, int fd) = 0;
    virtual void add_output_handler(Handler *, int fd) = 0;
    virtual void add_exception_handler(Handler *, int fd) = 0;
    virtual void add_timeout_handler(Handler *,
                                     unsigned long tmout) = 0;
    virtual void remove(Handler *, Event) = 0;
    virtual void run(bool infinite = true) = 0;
    virtual void exit() = 0;
    virtual void move(Dispatcher *) = 0;
    virtual bool idle() const = 0;
};

class StandardDispatcher : public Dispatcher
{
  public:
    StandardDispatcher();
    virtual ~StandardDispatcher();

    virtual void add_input_handler(Handler *, int fd);
    virtual void add_output_handler(Handler *, int fd);
    virtual void add_exception_handler(Handler *, int fd);
    virtual void add_timeout_handler(Handler *,
                                     unsigned long tmout);
    virtual void remove(Handler *, Event);
    virtual void run(bool infinite = true);
    virtual void exit();
    virtual void move(Dispatcher *);
    virtual bool idle() const;
  private:
    struct FileEvent
    {
        StandardDispatcher *disp;
	Handler *cb;
	Event ev;
        int fd;
        
	FileEvent() {}
	FileEvent(StandardDispatcher *_disp, Handler *_cb, Event _ev, int _fd)
	    : disp(_disp), cb(_cb), ev(_ev), fd(_fd)
          {}
    };
    struct TimerEvent
    {
        StandardDispatcher *disp;
	Handler *cb;
        struct timeval expiration;
        
	TimerEvent() {}
	TimerEvent(StandardDispatcher *_disp, Handler *_cb,
                   unsigned long tmout);
    };
    list<TimerEvent *> tm_handlers_;
    list<FileEvent *> fd_handlers_;
    fd_set rd_fds_, wr_fds_, ex_fds_;
    bool do_exit_;
};

}

#endif
