
#include "lib.h"

void 
strarr_del (char **table, int *ntable, char const *str)
{
  int
    i, j;

  for (i = 0; i < *ntable;)
    if (!strcmp (table[i], str))
      {
	for (j = i + 1; j < *ntable; j++)
	  table[j - 1] = table[j];
	(*ntable)--;
      }
    else
      i++;
}

#if HAVE_HSEARCH_R

#include <search.h>
#include <errno.h>

void 
strtab_del (char **table, int *ntable, char const *str)
{
  ENTRY e, *e_p;
  struct hsearch_data* hash_table_p = (struct hsearch_data*)table;

  e.key = str;
  hsearch_r (e, FIND, &e_p, hash_table_p);
  if(!e_p)
    ; /*error ("can't delete from hashtable:" "%s", strerror (errno)); */
  else
    {
      if ((int)e_p->data != -1)
	{
	  e.key = xstrdup (str);
	  e.data = (char*)-1;
	  hsearch_r (e, ENTER, &e_p, hash_table_p);
	  if(!e_p)
	    ; /*error ("can't delete from hashtable:" "%s", strerror (errno)); */
	  /* (*ntable)--; */
	}
    }
}

#endif /* HAVE_HSEARCH_R */
