
#include "lib.h"

int 
strarr_find (char **table, int ntable, char const *str)
{
  int
    i;

  if (!str || !*str)		/* sanity check */
    return (-1);

  for (i = 0; i < ntable; i++)
    if (!strcmp (table[i], str))
      return (i);

  return (-1);
}

#if HAVE_HSEARCH_R

#include <search.h>

int 
strtab_find (char **table, int ntable, char const *str)
{
  int i;
  ENTRY e, *e_p;
  struct hsearch_data* hash_table_p = (struct hsearch_data*)table;

  if (!ntable)		/* sanity check */
    return -1;
  
  if (!str || !*str)		/* sanity check */
    return (-1);

  e.key = str;
  hsearch_r (e, FIND, &e_p, hash_table_p);
  if (!e_p)
    return -1;

  return (int)e_p->data;
}

#endif /* HAVE_HSEARCH_R */
